% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{init}
\alias{init}
\title{Initialize Full Pipeline Script and Model Script}
\usage{
init(
  r_script_name = "full_pipeline.R",
  cpp_script_name = "model.cpp",
  path = here::here(),
  open_r_script = TRUE,
  setup_rscript = TRUE
)
}
\arguments{
\item{r_script_name}{Character. The name of the R script file to be created.
Defaults to `"full_pipeline.R"`.}

\item{cpp_script_name}{Character. The name of the C++ script file to be
created. Defaults to `"model.cpp"`.}

\item{path}{Character. The directory in which to create the scripts.
Defaults to `here::here()`.}

\item{open_r_script}{Logical. Whether to open the R script automatically in
RStudio (if available). Defaults to `TRUE`.}

\item{setup_rscript}{Logical. Whether to setup the R script with example
code. Defaults to `TRUE`.}
}
\value{
Invisibly returns a list containing:
\itemize{
  \item r_script_path: Path to the created R script
  \item cpp_script_path: Path to the created C++ script
}
The function also prints success messages upon script creation.
}
\description{
Creates a full pipeline R script and a model C++ script, saving them to the
appropriate folders within the project directory structure. The folder
structure is created using `AgePopDenom::create_project_structure()`.
The scripts contain example code for downloading and processing DHS data,
shapefiles, and running models.
}
\examples{
\donttest{
# Create temp directory with normalized path
tf <- file.path(tempdir(), "test_env")
dir.create(tf, recursive = TRUE, showWarnings = FALSE)

#  Initialize with normalized path
cpp_path <- file.path(tf, "02_scripts", "model")
dir.create(cpp_path, recursive = TRUE, showWarnings = FALSE)
cpp_path <- normalizePath(cpp_path, winslash = "/", mustWork = FALSE)

init(
r_script_name = "full_pipeline.R",
cpp_script_name = "model.cpp",
path = tf,
open_r_script = FALSE
)
}
}
