% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{autofitVariogram}
\alias{autofitVariogram}
\title{Automatically Fit a Variogram Model}
\usage{
autofitVariogram(
  formula,
  input_data,
  model = c("Sph", "Exp", "Gau", "Ste"),
  kappa = c(0.05, seq(0.2, 2, 0.1), 5, 10),
  fix.values = c(NA, NA, NA),
  verbose = FALSE,
  GLS.model = NA,
  start_vals = c(NA, NA, NA),
  miscFitOptions = list(),
  ...
)
}
\arguments{
\item{formula}{model formula for the variogram (e.g., `z ~ 1`)}

\item{input_data}{an `sf` or `Spatial*` object containing the spatial data}

\item{model}{a character vector of variogram model names (e.g., `"Sph"`, `"Exp"`)}

\item{kappa}{vector of kappa values for Matern/Stein models}

\item{fix.values}{optional vector of fixed values for nugget, range, sill}

\item{verbose}{logical; if `TRUE`, prints additional output}

\item{GLS.model}{optional variogram model for Generalized Least Squares}

\item{start_vals}{optional vector of starting values for nugget, range, sill}

\item{miscFitOptions}{named list of additional control options}

\item{...}{additional arguments passed to `gstat::variogram()`}
}
\value{
a list with class `"autofitVariogram"` containing:
\describe{
  \item{exp_var}{the empirical variogram}
  \item{var_model}{the best-fit variogram model object}
  \item{sserr}{sum of squared errors for the best model}
}
}
\description{
This function was originally sourced from the `automap` package
(version 1.1-16), which is no longer available on CRAN. It is provided
here with minimal modification for internal use in this package.

`autofitVariogram()` automates the fitting of a variogram model to spatial
input data by testing a range of model types and kappa values (for Matern
and Stein models), and selecting the best-fit model based on the sum of
squared errors.

Dependencies from `gstat`, `sp`, and `sf` are required for this function
to operate correctly.
}
\note{
Original author: J. H. Hiemstra (2013), `automap` package.
License: GPL-2 | GPL-3.
}
\examples{
\dontrun{
result <- autofitVariogram(z ~ 1, input_data)
plot(result$exp_var)
plot(result$var_model)
}

}
\keyword{gstat}
\keyword{kriging}
\keyword{spatial}
\keyword{variogram}
