% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{compute_cov}
\alias{compute_cov}
\title{Compute Covariance Matrix for Spatial Model}
\usage{
compute_cov(
  gamma,
  sigma2,
  phi,
  u_dist,
  n_x,
  tau2_1 = 1,
  tau2_2 = 1,
  age_param_data
)
}
\arguments{
\item{gamma}{Correlation parameter between the two spatial processes}

\item{sigma2}{Variance parameter for the spatial processes}

\item{phi}{Range parameter for the spatial correlation}

\item{u_dist}{Distance matrix between locations}

\item{n_x}{Number of spatial locations}

\item{tau2_1}{Variance parameter for first process (default = 1)}

\item{tau2_2}{Variance parameter for second process (default = 1)}

\item{age_param_data}{List containing age-structured parameters:
\itemize{
  \item b1: Vector of age parameters for first process
  \item b2: Vector of age parameters for second process
  \item c: Vector of cross-process age parameters
}}
}
\value{
A sparse symmetric matrix of dimension 2n_x × 2n_x
}
\description{
This function computes a block covariance matrix for a bivariate spatial
model with age-structured parameters.
}
