% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_function.R
\name{summarise_anova}
\alias{summarise_anova}
\title{Utils: Summary of Analysis of Variance and Test of Means}
\usage{
summarise_anova(
  analysis,
  inf = "p",
  design = "DIC",
  round = 3,
  divisor = FALSE
)
}
\arguments{
\item{analysis}{List with the analysis outputs of the DIC, DBC, DQL, FAT2DIC, FAT2DBC, PSUBDIC and PSUBDBC functions}

\item{inf}{Analysis of variance information (can be "p", "f", "QM" or "SQ")}

\item{design}{Type of experimental project (DIC, DBC, DQL, FAT2DIC, FAT2DBC, PSUBDIC or PSUBDBC)}

\item{round}{Number of decimal places}

\item{divisor}{Add divider between columns}
}
\value{
returns a data.frame or print with a summary of the analysis of several experimental projects.
}
\description{
Summarizes the output of the analysis of variance and the multiple comparisons test for completely randomized (DIC), randomized block (DBC) and Latin square (DQL) designs.
}
\note{
Adding table divider can help to build tables in microsoft word. Copy console output, paste into MS Word, Insert, Table, Convert text to table, Separated text into:, Other: |.

The column names in the final output are imported from the ylab argument within each function.

This function is only for declared qualitative factors. In the case of a quantitative factor and the other qualitative in projects with two factors, this function will not work.

Triple factorials and split-split-plot do not work in this function.
}
\examples{


library(AgroR)

#=====================================
# DIC
#=====================================
data(pomegranate)
attach(pomegranate)
a=DIC(trat, WL, geom = "point", ylab = "WL")
b=DIC(trat, SS, geom = "point", ylab="SS")
c=DIC(trat, AT, geom = "point", ylab = "AT")
summarise_anova(analysis = list(a,b,c), divisor = TRUE)
library(knitr)
kable(summarise_anova(analysis = list(a,b,c), divisor = FALSE))

#=====================================
vari=c("WL","SS","AT")
output=lapply(vari,function(x){
output=DIC(trat,response = unlist(pomegranate[,x]),ylab = parse(text=x),print.on=FALSE)})
summarise_anova(analysis = output, divisor = TRUE)

#=====================================
# DBC
#=====================================
data(soybean)
attach(soybean)
a=DBC(cult,bloc,prod,ylab = "Yield")
summarise_anova(list(a),design = "DBC")

#=====================================
# FAT2DIC
#=====================================
data(corn)
attach(corn)
a=FAT2DIC(A, B, Resp, quali=c(TRUE, TRUE))
summarise_anova(list(a),design="FAT2DIC")
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}
}
