% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_loadDaily.R
\name{airsis_loadDaily}
\alias{airsis_loadDaily}
\title{Load daily AIRSIS monitoring data}
\usage{
airsis_loadDaily(
  archiveBaseUrl = paste0("https://airfire-data-exports.s3.us-west-2.amazonaws.com/",
    "monitoring/v2"),
  archiveBaseDir = NULL,
  QC_negativeValues = c("zero", "na", "ignore"),
  QC_removeSuspectData = TRUE
)
}
\arguments{
\item{archiveBaseUrl}{Base URL for monitoring v2 data files.}

\item{archiveBaseDir}{Local base directory for monitoring v2 data files.}

\item{QC_negativeValues}{Type of QC to apply to negative values.}

\item{QC_removeSuspectData}{Removes monitors determined to be misbehaving.}
}
\value{
A \emph{mts_monitor} object with AIRSIS data. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Loads pre-generated .rda files containing daily
AIRSIS data.

If \code{archiveDataDir} is defined, data will be loaded from this local
archive. Otherwise, data will be loaded from the monitoring data repository
maintained by the USFS AirFire team.

The files loaded by this function are updated once per day and
contain data for the previous 45 days.

For the most recent data in the last 10 days, use \code{airsis_loadLatest()}.

For data extended more than 45 days into the past, use \code{airsis_loadAnnual()}.
}
\note{
Some older AIRSIS timeseries contain only values of 0, 1000, 2000, 3000, ... ug/m3.
Data from these deployments pass instrument-level QC checks but these
timeseries generally do not represent valid data and should be removed.
With \code{QC_removeSuspectData = TRUE} (the default), data is checked and
periods reporting only values of 0:10 * 1000 ug/m3 are invalidated.

Only those personally familiar with the individual instrument deployments
should work with the "suspect" data.
}
\examples{
\dontrun{
library(AirMonitor)

# Fail gracefully if any resources are not available
try({

airsis_loadDaily()\ \%>\\%
  monitor_filter(stateCode == "CA") \\%>\\%
  monitor_leaflet()

}, silent = FALSE)
}
}
\seealso{
\code{\link{airsis_loadAnnual}}

\code{\link{airsis_loadLatest}}
}
