% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Birmingham.R
\docType{data}
\name{Birmingham}
\alias{Birmingham}
\title{Birmingham Airport data}
\format{
A data frame with 11 rows and 9 columns (variables):
\describe{
\item{type}{Aircraft type}
\item{i}{Aircraft index (subscript)}
\item{eta}{Number of movements}
\item{p}{Average fee per movement (in pounds)}
\item{d}{Estimated diversion cost per movement (in pounds)}
\item{b}{Average benefit per movement (in pounds)}
\item{l}{Runway user index}
\item{c}{Maintenance cost per movement (in pounds)}
\item{g}{Assumed capital cost (in pounds)}
}
}
\source{
Littlechild, S. C. and Thompson, G. F. (1977). Aircraft landing fees: a game theory approach.
\emph{The Bell Journal of Economics}, 8, 186-204.
}
\usage{
Birmingham
}
\description{
The data includes several variables describing 13,572 aircraft operations — 6,876 take-offs and 6,876 landings —
involving 11 different aircraft types at Birmingham Airport during the period 1968–1969.
}
\examples{
# Based on capital cost (g)
G <- multiclonesrules(Birmingham$g, Birmingham$eta, c("SEC", "CEC", "SM"), 
group_contribution = FALSE, agents_names = Birmingham$i, labels = FALSE)
(cost_allocation <- round(G, 2))

# Based on capital cost (g) + add maintenance cost per movement (c)
sweep(cost_allocation, MARGIN = 2, Birmingham$c, FUN = "+")
}
\keyword{datasets}
