% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{GenGeno}
\alias{GenGeno}
\title{Generate Genotypes}
\usage{
GenGeno(n, snps, maf_range = c(0.001, 0.005), prop_anno = c(0.5, 0.4, 0.1))
}
\arguments{
\item{n}{Sample size.}

\item{snps}{Number of SNP in the gene.}

\item{maf_range}{Range of minor allele frequencies: c(MIN, MAX).}

\item{prop_anno}{Proportions of annotations in each category. Length should
equal the number of annotation categories. Default of c(0.5, 0.4, 0.1) is
based on the approximate empirical frequencies of BMVs, DMVs, and PTVs.}
}
\value{
List containing the (n x snps) genotype matrix "geno" and the
(snps x 1) annotation vector "anno".
}
\description{
Generates genotypes in linkage equilibrium with accompanying annotations.
}
