% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelic_series_sumstats.R
\name{COASTSS}
\alias{COASTSS}
\title{COding-variant Allelic Series Test from Summary Statistics}
\usage{
COASTSS(
  anno,
  beta,
  se,
  check = TRUE,
  eps = 1,
  lambda = c(1, 1, 1),
  ld = NULL,
  maf = NULL,
  pval_weights = c(0.25, 0.25, 0.5),
  weights = c(1, 2, 3)
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with integer values in 1 through
the number of annotation categories L.}

\item{beta}{(snps x 1) vector of effect sizes for the coding genetic variants
within a gene.}

\item{se}{(snps x 1) vector of standard errors for the effect sizes.}

\item{check}{Run input checks? Default: TRUE.}

\item{eps}{Epsilon added to the diagonal of the LD matrix if not positive
definite. Note, epsilon should increase as the sample size decreases.}

\item{lambda}{Optional (3 x 1) vector of inflation factors, one for each
component test. Defaults to a 1s vector, which results in no rescaling.}

\item{ld}{(snps x snps) matrix of correlations among the genetic variants.
Although ideally provided, an identity matrix is assumed if not.}

\item{maf}{(snps x 1) vector of minor allele frequencies. Although ideally
provided, defaults to the zero vector.}

\item{pval_weights}{(3 x 1) vector of relative weights for combining the
component tests to perform the omnibus test. The default of
c(0.25, 0.25, 0.50) gives the SKAT test equal weight to the two burden tests.}

\item{weights}{(L x 1) vector of annotation category weights. Note that the
number of annotation categories L is inferred from the length of \code{weights}.}
}
\value{
Numeric p-value.
}
\description{
Main function for performing the allelic series test from summary statistics.
Performs both Burden and SKAT type tests, then combines the results to
calculate an omnibus p-value. Note that not all tests included in
\code{\link{COAST}} are available when working with summary statistics.
}
\examples{
# Generate data.
data <- DGP(n = 1e3)
sumstats <- CalcSumstats(data = data)

# Run the Coding-variant Allelic Series Test from summary statistics.
results <- COASTSS(
  anno = sumstats$sumstats$anno,
  beta = sumstats$sumstats$beta, 
  se = sumstats$sumstats$se,
  ld = sumstats$ld,
  maf = sumstats$sumstats$maf,
)
show(results)
}
