% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.AlphaPart}
\alias{summary.AlphaPart}
\title{A function to summarize AlphaPart object.}
\usage{
\method{summary}{AlphaPart}(object, by, FUN, labelSum, subset,
  sums, cov,  ...)
}
\arguments{
\item{object}{AlphaPart, output object from
\code{\link[AlphaPart]{AlphaPart}} function.}

\item{by}{Character, the name of a column by which summary function
FUN should be applied; if \code{NULL} (default) summary is given
for the whole table.}

\item{FUN}{Function, which function should be used in summary;
function should return single value per each level of by.}

\item{labelSum}{Character, label used for the overall breeding value.}

\item{subset}{Logical, perform summary only on a subset of
\code{object} subsetted by this argument.}

\item{sums}{Logical, link between \code{\link[AlphaPart]{AlphaPart}}
and \code{summary.AlphaPart()} (only for internal use!).}

\item{cov}{Logical, if FALSE returns \code{n} variances plus one
additional column containing two times the sum of all covariances;
otherwise returns \code{n} variance and \code{n(n-1)/2} covariances
in the form of \code{2*Cov(., .)}, where \code{n} is the number of
partitions. This argument only works when \code{FUN = var}. Defaut
\code{cov = FALSE}.}

\item{...}{Arguments passed to other functions (not used at the
moment).}
}
\value{
An object of class \code{summaryAlphaPart}, which is a list
of data frames with summary statistics on breeding value
partitions. For each trait there a dataframe holds summary for the
"whole/original" breeding value and its partitions.  In addition
another list is added (named \code{info}) with the following
components holdinfg meta info:
\itemize{
\item \code{path} column name holding path information
\item \code{nP} number of paths
\item \code{lP} path labels
\item \code{nT} number of traits
\item \code{lT} trait labels
\item \code{by} column name of variable by which summary was performed
\item \code{warn} potential warning messages associated with this object
\item \code{labelSum} column name of summary for "whole/original" breeding values
}

There is a handy plot method (\code{\link[AlphaPart]{plot.summaryAlphaPart}}) for output.
}
\description{
Breedng values of individuals are often summarized,
either by year of birth or some other classification. Function
\code{summary.AlphaPart} provides a way to ease the computation of
such summaries on partitions of breeding values.
}
\examples{
## --- Partition additive genetic values by loc ---
res <- AlphaPart(x=AlphaPart.ped, colPath="country", colBV=c("bv1", "bv2"))

## Summarize whole population
ret <- summary(res)

## Summarize population by generation (=trend)
ret <- summary(res, by="gen")

## Summarize population by generation (=trend) but only for domestic location
ret <- summary(res, by="gen", subset=res[[1]]$country == "domestic")

## --- Partition additive genetic values by loc and gender ---

AlphaPart.ped$country.gender <- with(AlphaPart.ped, paste(country, gender, sep="-"))
res <- AlphaPart(x=AlphaPart.ped, colPath="country.gender", colBV=c("bv1", "bv2"))

## Summarize population by generation (=trend)
ret <- summary(res, by="gen")

## Summarize population by generation (=trend) but only for domestic location
ret <- summary(res, by="gen", subset=res[[1]]$country == "domestic")
}
\seealso{
\code{\link[AlphaPart]{AlphaPart}} for partitioning breeding
values, \code{\link[AlphaPart]{plot.summaryAlphaPart}} for plotting
output of summary method
}
