% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recAncestor.R
\name{recAncestor}
\alias{recAncestor}
\title{Recursive Ancestor Detection}
\usage{
recAncestor(pmat)
}
\arguments{
\item{pmat}{A boolean matrix indicating whether a connection was detected.}
}
\value{
A boolean matrix indicating whether a connection was detected or constructed.
}
\description{
This function recursively detects all ancestors of a given set of variables in a matrix.
Adds ancestors of ancestors to the output matrix.
}
\examples{
# random DAGS for simulation
set.seed(1234)

p <- 5 #number of nodes
DAG <- pcalg::randomDAG(p, prob = 0.5)

B <- matrix(0, p, p) # represent DAG as matrix
for (i in 2:p){
  for(j in 1:(i-1)){
    # store edge weights
    B[i,j] <- max(0, DAG@edgeData@data[[paste(j,"|",i, sep="")]]$weight)
  }
}
colnames(B) <- rownames(B) <- LETTERS[1:p]

# edge effects to adjecency matrix
B <- B != 0

# transform adjacency matrix to ancestral matrix
recAncestor(B)
}
\seealso{
\code{\link{AncReg}}, \code{\link{summary_graph}}
}
