% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_plot_tree.R
\name{Af_plot_tree}
\alias{Af_plot_tree}
\title{Plots lineage tree of clonotype from AntibodyForests object}
\usage{
Af_plot_tree(
  AntibodyForests_object,
  sample,
  clonotype,
  show.inner.nodes,
  x.scaling,
  y.scaling,
  color.by,
  label.by,
  node.size,
  node.size.factor,
  node.size.scale,
  node.size.range,
  node.color,
  node.color.gradient,
  node.color.range,
  node.label.size,
  arrow.size,
  edge.width,
  edge.label,
  show.color.legend,
  show.size.legend,
  main.title,
  sub.title,
  color.legend.title,
  size.legend.title,
  font.size,
  output.file
)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests object - AntibodyForests object as obtained from the 'Af_build()' function in Platypus.}

\item{sample}{string - denotes the sample that contains the clonotype.}

\item{clonotype}{string - denotes the clonotype from which the lineage tree should be plotted.}

\item{show.inner.nodes}{boolean - if TRUE, the tree with inner nodes is plotted (only present when the trees are created with the 'phylo.tree.nj', 'phylo.tree.mp', phylo.tree.ml', or 'phylo.tree.IgPhyML' construction algorithm). Defaults to FALSE.}

\item{x.scaling}{float - specifies the range of the x axis and thereby scales the horizontal distance between the nodes. Defaults to a scaling in which the minimum horizontal space between two nodes equals 20\% of the radius of the smallest node present in the tree (calculated using the 'calculate_optimal_x_scaling()' function).}

\item{y.scaling}{float - specifies the range of the y axis and thereby scales the vertical distance between the nodes. Defaults to a scaling in which the vertical space between the centers of two nodes equals 0.25 points in the graph.}

\item{color.by}{string - specifies the feature of the nodes that will be used for coloring the nodes. This sublist should be present in each sublist of each node in the 'nodes' objects within the AntibodyForests object. For each unique value for the selected feature, a unique color will be selected using the 'grDevices::rainbow()' function (unless a color gradient is created, see 'node.color.gradient' parameter). Defaults to 'isotype' (if present as feature of all nodes), otherwise defaults to NULL.}

\item{label.by}{string - specifies what should be plotted on the nodes. Options: 'name', 'size', a feature that is stored in the 'nodes' list, and 'none'. Defaults to 'name'.}

\item{node.size}{string or integer or list of integers - specifies the size of the nodes. If set to 'expansion', the nodes will get a size that is equivalent to the number of cells that they represent. If set to an integer, all nodes will get this size. If set to a list of integers, in which each item is named according to a node, the nodes will get these sizes. Defaults to 'expansion'.}

\item{node.size.factor}{integer - factor by which all node sizes are multiplied. Defaults to 1.}

\item{node.size.scale}{vector of 2 integers - specifies the minimum and maximum node size in the plot, to which the number of cells will be scaled. Defaults to 10 and 30.}

\item{node.size.range}{vector of 2 integers - specifies the the range of the node size scale. Defaults to the minimum and maximum node size.}

\item{node.color}{string or list of strings - specifies the color of nodes. If set to 'default', and the 'color.by' parameter is not specified, all the seqeuence-recovered nodes are colored lightblue. If set to 'default', and the 'color.by' parameter is set to a categorical value, the sequence-recovered nodes are colored  If set to a color (a color from the 'grDevices::color()' list or a valid HEX code), all the sequence-recovered nodes will get this color. If set to a list of colors, in which each item is named to a node, the nodes will get these colors. Defaults to 'default'.}

\item{node.color.gradient}{vector of strings - specifies the colors of the color gradient, if 'color.by' is set to a numerical feature. The minimum number of colors that need to be specified are 2. Defaults to 'viridis'.}

\item{node.color.range}{\itemize{
\item vector of 2 floats - specifies the range of the color gradient. Defaults to the minimum and maximum value found for the feature selected by the 'color.by' parameter.
}}

\item{node.label.size}{float - specifies the font size of the node label. Default scales to the size of the nodes.}

\item{arrow.size}{float - specifies the size of the arrows. Defaults to 1.}

\item{edge.width}{float - specifies the width of the edges. Defaults to 1.}

\item{edge.label}{string - specifies what distance between the nodes is shown as labels of the edges. Options: 'original' (distance that is stored in the igraph object), 'none' (no edge labels are shown), 'lv' (Levensthein distance), 'dl' (Damerau-Levenshtein distance), 'osa' (Optimal String Alignment distance), and 'hamming' (Hamming distance). Defaults to 'none'.}

\item{show.color.legend}{boolean - if TRUE, a legend is plotted to display the values of the specified node feature matched to the corresponding colors. Defaults to TRUE if the 'color.by' parameter is specified.}

\item{show.size.legend}{boolean - if TRUE, a legend is plotted to display the node sizes and the corresponding number of cells represented. Defaults to TRUE if the 'node.size' parameter is set to 'expansion'.}

\item{main.title}{string - specifies the main title of the plot (to be plotted in a bold font). Defaults to NULL.}

\item{sub.title}{string - specifies the sub title of the plot (to be plotted in an italic font below the main title). Defaults to NULL.}

\item{color.legend.title}{string - specifies the title of the legend showing the color matching. Defaults to the (capitalized) name of the feature specified in the 'color.by' parameter (converted by the 'stringr::str_to_title()' function).}

\item{size.legend.title}{string - specifies the title of the legend showing the node sizes. Defaults to 'Expansion (# cells)'.}

\item{font.size}{float - specifies the font size of the text in the plot. Defaults to 1.}

\item{output.file}{string - specifies the path to the output file (PNG of PDF). Defaults to NULL.}
}
\value{
No value returned, plots the lineage tree for the specified clonotype on the device or saves it to the output.file.
}
\description{
This function retrieves the igraph object from the provided AntibodyForests object for the specified clone within the specified sample and plots the lineage tree using the specified plotting parameters.
}
\examples{
Af_plot_tree(AntibodyForests::small_af,
                     sample = "S1",
                     clonotype = "clonotype1",
                     main.title = "Lineage tree",
                     sub.title = "Sample 1 - clonotype 1")
}
