% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_to_newick.R
\name{Af_to_newick}
\alias{Af_to_newick}
\title{Saves an AntibodyForests-object into a newick file}
\usage{
Af_to_newick(AntibodyForests_object, min.nodes, output.file)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests-object, output from Af_build()}

\item{min.nodes}{The minimum number of nodes in a tree to calculate metrics (including the germline).}

\item{output.file}{string - specifies the path to the output file}
}
\value{
No value returned, saves the newick format to the output.file
}
\description{
Saves an AntibodyForests-object into a newick file. The node labels will have the format node\@size where size is the size of the node.
}
\examples{
\dontrun{
Af_to_newick(AntibodyForests_object = AntibodyForests::small_af,
              min.nodes = 2,
              output.file = "output.newick")
}
}
