% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApacheLogProcessor.R
\name{read.multiple.apache.access.log}
\alias{read.multiple.apache.access.log}
\title{Reads multiple files of apache web server.}
\usage{
read.multiple.apache.access.log(path, prefix, verbose = TRUE, ...)
}
\arguments{
\item{path}{path where the files are located}

\item{prefix}{the prefix that identify the logs files}

\item{verbose}{if prints messages during the processing}

\item{...}{parameter to be passed to read.apache.access.log function}
}
\value{
a data frame with the apache log files information.
}
\description{
The files can be gziped or not. If the files are gziped they are extracted once at time, processed and after only the extracted file is deleted.
}
\examples{
path <- system.file("examples", package="ApacheLogProcessor")
path <- paste(path, "/", sep="")

#read multiple gziped logs with the prefix m_access_log_combined_
dfLog <- read.multiple.apache.access.log(path, "m_access_log_combined_")

}
\author{
Diogo Silveira Mendonca
}
