% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CumulativeEvents-class}
\alias{CumulativeEvents-class}
\alias{.CumulativeEvents}
\title{Cumulative Events}
\description{
An S4 class to store the result of a \link[=tempo]{tempo} plot.
}
\section{Slots}{

\describe{
\item{\code{lower}}{A \code{\link{numeric}} vector giving the lower boundaries of the
credibility interval expressed in \emph{\link[aion:RataDie-class]{rata die}}.}

\item{\code{upper}}{A \code{\link{numeric}} vector giving the upper boundaries of the
credibility interval expressed in \emph{\link[aion:RataDie-class]{rata die}}.}

\item{\code{level}}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{\code{gauss}}{A \code{\link{logical}} scalar indicating if the Gaussian approximation of
the credible interval was used.}

\item{\code{counts}}{A \code{\link{logical}} scalar.}

\item{\code{events}}{An \code{\link{integer}} scalar giving the number of events included in
the tempo plot.}

\item{\code{hash}}{A \code{\link{character}} string giving the 32-byte MD5 hash of the
original data file.}
}}

\note{
This class inherits from \code{\link[aion:TimeSeries-class]{aion::TimeSeries}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is a \code{CumulativeEvents} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
Other classes: 
\code{\link{ActivityEvents-class}},
\code{\link{AgeDepthModel-class}},
\code{\link{DurationsMCMC-class}},
\code{\link{EventsMCMC-class}},
\code{\link{MCMC-class}},
\code{\link{OccurrenceEvents-class}},
\code{\link{PhasesMCMC-class}},
\code{\link{TimeRange-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
