% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{meta_nodes_search_node}
\alias{meta_nodes_search_node}
\title{Search a node by its id field, or its name field}
\usage{
meta_nodes_search_node(
  meta_node,
  id = NULL,
  name = NULL,
  limit = 10,
  full_data = TRUE,
  mode = c("table", "raw")
)
}
\arguments{
\item{meta_node}{Name of a meta node (e.g. Gwas). Use \code{meta_nodes_list} to get the full list of meta nodes.}

\item{id}{The id field of a node (e.g. "ieu-a-2" for a Gwas).
Use EpiGraphDB web UI to get a sense of what those ids are for entities.}

\item{name}{The name field of a node (e.g. "body mass index" for a Gwas).
Use EpiGraphDB web UI to get a sense of what those names are for entities.}

\item{limit}{Max number of items to retrieve.}

\item{full_data}{When False, only return the id and name fields (their specific names differ in specific nodes) for a node.
This is useful if you want your queries to return results faster with smaller amount of data requested.}

\item{mode}{If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \code{GET /meta/nodes/{meta_node}/search}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#get-metanodesmeta_nodesearch}{\code{GET /meta/nodes/{meta_node}/search}}
}
\examples{
# List the first 5 MR relationships
meta_rels_list_rel(meta_rel = "MR", limit = 5)
}
