% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_transform}
\alias{g_transform}
\title{Apply a coordinate transformation to a WKT geometry}
\usage{
g_transform(
  wkt,
  srs_from,
  srs_to,
  wrap_date_line = FALSE,
  date_line_offset = 10L
)
}
\arguments{
\item{wkt}{Character. OGC WKT string for a simple feature geometry.}

\item{srs_from}{Character string in OGC WKT format specifying the
spatial reference system for the geometry given by \code{wkt}.}

\item{srs_to}{Character string in OGC WKT format specifying the target
spatial reference system.}

\item{wrap_date_line}{Logical scalar. \code{TRUE} to correct geometries that
incorrectly go from a longitude on a side of the antimeridian to the other
side. Defaults to \code{FALSE}.}

\item{date_line_offset}{Integer scalar. Longitude gap in degree. Defaults
to \code{10}.}
}
\value{
Character string for a transformed OGC WKT geometry.
}
\description{
\code{g_transform()} will transform the coordinates of a geometry from their
current spatial reference system to a new target spatial reference system.
Normally this means reprojecting the vectors, but it could include datum
shifts, and changes of units.
}
\note{
This function uses the \code{OGR_GeomTransformer_Create()} and
\code{OGR_GeomTransformer_Transform()} functions in the GDAL API: "This is an
enhanced version of \code{OGR_G_Transform()}. When reprojecting geometries from
a Polar Stereographic projection or a projection naturally crossing the
antimeridian (like UTM Zone 60) to a geographic CRS, it will cut geometries
along the antimeridian. So a \code{LineString} might be returned as a
\code{MultiLineString}."

The \code{wrap_date_line = TRUE} option might be specified for circumstances to
correct geometries that incorrectly go from a longitude on a side of the
antimeridian to the other side, e.g., \verb{LINESTRING (-179 0,179 0)} will be
transformed to \verb{MULTILINESTRING ((-179 0,-180 0),(180 0,179 0))}. For that
use case, \code{srs_to} might be the same as \code{srs_from}.
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file)

# the convenience function bbox_transform() does this:
bbox_to_wkt(ds$bbox()) |>
  g_transform(ds$getProjection(), epsg_to_wkt(4326)) |>
  bbox_from_wkt()

ds$close()

# correct geometries that incorrectly go from a longitude on a side of the
# antimeridian to the other side
geom <- "LINESTRING (-179 0,179 0)"
srs <- epsg_to_wkt(4326)
g_transform(geom, srs, srs, wrap_date_line = TRUE)
}
\seealso{
\code{\link[=bbox_transform]{bbox_transform()}}
}
