% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_util.R
\name{translate}
\alias{translate}
\title{Convert raster data between different formats}
\usage{
translate(src_filename, dst_filename, cl_arg = NULL, quiet = FALSE)
}
\arguments{
\item{src_filename}{Either a character string giving the filename of the
source raster, or an object of class \code{GDALRaster} for the source.}

\item{dst_filename}{Character string. Filename of the output raster.}

\item{cl_arg}{Optional character vector of command-line arguments for
\code{gdal_translate} (see URL above).}

\item{quiet}{Logical scalar. If \code{TRUE}, a progress bar will not be
displayed. Defaults to \code{FALSE}.}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{translate()} is a wrapper of the \command{gdal_translate} command-line
utility (see \url{https://gdal.org/en/stable/programs/gdal_translate.html}).
The function can be used to convert raster data between different
formats, potentially performing some operations like subsetting,
resampling, and rescaling pixels in the process. Refer to the GDAL
documentation at the URL above for a list of command-line arguments that
can be passed in \code{cl_arg}.
}
\examples{
# convert the elevation raster to Erdas Imagine format and resample to 90m
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
img_file <- file.path(tempdir(), "storml_elev_90m.img")

# command-line arguments for gdal_translate
args <- c("-tr", "90", "90", "-r", "average")
args <- c(args, "-of", "HFA", "-co", "COMPRESSED=YES")

translate(elev_file, img_file, args)

ds <- new(GDALRaster, img_file)
ds$info()

ds$close()
\dontshow{deleteDataset(img_file)}
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=rasterFromRaster]{rasterFromRaster()}}, \code{\link[=warp]{warp()}}

\code{\link[=ogr2ogr]{ogr2ogr()}} for vector data
}
