% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_crownseg.R
\name{chmseg_RL}
\alias{chmseg_RL}
\title{Watershed segmentation based on 'rLiDAR'}
\usage{
chmseg_RL(treepos = NULL, chm = NULL, maxCrownArea = 150,
  exclusion = 0.2)
}
\arguments{
\item{treepos}{numeric. \code{matrix} or \code{data.frame} with three columns (tree xy coordinates and height).
number of crown segments equal to the number of treetops.}

\item{chm}{raster*. Canopy height model in \code{raster} or \code{SpatialGridDataFrame} file format. Should be the same that was used to create
the input for \code{treepos}.}

\item{maxCrownArea}{numeric. A single value of the maximum individual tree crown radius expected. Default 10.0 m.
height of \code{treepos}.}

\item{exclusion}{numeric. A single value from 0 to 1 that represents the percent of pixel exclusion.}
}
\description{
'rLiDAR' segmentation of individual tree crowns based on a canopy height model and initial seeding points (trees). Generic segmentation algorithm
Carlos A. Silva et all.: R package \href{https://CRAN.R-project.org/package=rLiDAR}{rLiDAR}\cr
}
\examples{
\dontrun{
## required packages
 require(uavRst)
## read chm and tree position data
 data(chm_seg)
 data(trp_seg)
## segmentation
 crownsRL <- chmseg_RL(chm= chm_seg[[1]],
                       treepos= trp_seg[[1]],
                       maxCrownArea = 150,
                       exclusion = 0.2)
## visualisation
 raster::plot(crownsRL)
 } 
}
