% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_treepos.R
\name{treepos_lidR}
\alias{treepos_lidR}
\title{tree top detection based on local maxima filters as provided by 'lidR'}
\usage{
treepos_lidR(chm = NULL, movingWin = 7, minTreeAlt = 2)
}
\arguments{
\item{chm}{Canopy height model in \code{raster}, \code{lasmetrics}, \code{matrix} or  object of \code{class LAS}.
Should be the same that was used to create
the input for \code{treepos}.}

\item{movingWin}{Size (in pixels) of the moving window to detect local maxima.}

\item{minTreeAlt}{Height threshold (m) below a pixel cannot be a local maximum. Local maxima values are used to define tree tops.}
}
\description{
Tree top detection based on local maxima filters. There are two types of filter. The first,
called for gridded objects, works on images with a matrix-based algorithm. And the second one, called for
point clouds, works at the point cloud level without any rasterization. Jean-Romain Roussel and David Auty:
R package \href{https://CRAN.R-project.org/package=lidR}{lidR}\cr
}
\examples{
\dontrun{
require(uavRst)
## required packages
require(uavRst)

 data(chm_seg)

## find trees
tPoslidR <- treepos_lidR(chm = chm_seg[[1]],
                    movingWin = 3,
                    minTreeAlt = 15)
## visualisation
# mapview::mapview(tPoslidR)
raster::plot(tPoslidR)
}
}
