% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AsyK.R
\name{plot.RIG}
\alias{plot.RIG}
\title{Density Plot by Reciprocal Inverse Gaussian kernel}
\usage{
\method{plot}{RIG}(x, ...)
}
\arguments{
\item{x}{an object of class "RIG"}

\item{\dots}{Not presently used in this implementation}
}
\value{
nothing
}
\description{
Plot density by using Reciprocal Inverse Gaussian Kernel.
}
\examples{
y <- rexp(200, 1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
xx <- seq(min(y) + 0.05, max(y), length = 200)
den <- RIG(x = xx, y = y, k = 200, h = h)
plot(den, type = "l")


##other details can also be added
y <- rexp(200, 1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
den <- RIG(x = xx, y = y, k = 200, h = h)
plot(den, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")

## To add true density along with estimated
d1 <- density(y, bw = h)
lines(d1, type = "p", col = "red")
legend("topright", c("Real Density", "Density by RIG Kernel"),
col = c("red", "black"), lty = c(1, 2))
}
\references{
Scaillet, O. 2004. Density estimation using inverse and reciprocal inverse Gaussian kernels. 	 \emph{Nonparametric Statistics}, \strong{16}, 217-226.
}
\seealso{
To examine RIG estimated values for density see \code{\link{RIG}} and for Mean Squared Error \code{\link{mse}}. Similarly, for plot of Laplace kernel \code{\link{plot.Laplace}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
