% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{get_key_vault}
\alias{get_key_vault}
\alias{list_key_vaults}
\title{Get existing Azure Key Vault}
\description{
Methods for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{get_key_vault(name)
list_key_vaults()
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: For \code{get_key_vault()}, the name of the key vault.
}
}

\section{Value}{

For \code{get_key_vault()}, an object of class \code{az_key_vault} representing the vault.

For \code{list_key_vaults()}, a list of such objects.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$list_key_vaults()

rg$get_key_vault("mykeyvault")

}
}
\seealso{
\link{create_key_vault}, \link{delete_key_vault}, \link{az_key_vault}

\href{https://learn.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://learn.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
