% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueueMessage.R
\name{QueueMessage}
\alias{QueueMessage}
\alias{message}
\title{R6 class representing a message from an Azure storage queue}
\description{
This class stores the data, metadata and behaviour associated with a message.

To generate a message object, call one of the methods exposed by the \code{\link{StorageQueue}} class.
}
\examples{
\dontrun{

endp <- storage_endpoint("https://mystorage.queue.core.windows.net", key="key")
queue <- storage_queue(endp, "queue1")

msg <- queue$get_message()
msg$update(visibility_timeout=60, text="updated message")
msg$delete()

}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{queue}}{The queue this message is from, an object of class \code{\link{StorageQueue}}}

\item{\code{id}}{The message ID.}

\item{\code{insertion_time}}{The message insertion (creation) time.}

\item{\code{expiry_time}}{The message expiration time.}

\item{\code{text}}{The message text.}

\item{\code{receipt}}{A pop receipt. This is present if the message was obtained by means other than \link[=StorageQueue]{peeking}, and is required for updating or deleting the message.}

\item{\code{next_visible_time}}{The time when this message will be next visible.}

\item{\code{dequeue_count}}{The number of times this message has been read.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QueueMessage-new}{\code{QueueMessage$new()}}
\item \href{#method-QueueMessage-delete}{\code{QueueMessage$delete()}}
\item \href{#method-QueueMessage-update}{\code{QueueMessage$update()}}
\item \href{#method-QueueMessage-print}{\code{QueueMessage$print()}}
\item \href{#method-QueueMessage-clone}{\code{QueueMessage$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueueMessage-new"></a>}}
\if{latex}{\out{\hypertarget{method-QueueMessage-new}{}}}
\subsection{Method \code{new()}}{
Creates a new message object. Rather than calling the \code{new} method manually, objects of this class should be created via the methods exposed by the \code{\link{StorageQueue}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueueMessage$new(message, queue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{message}}{Details about the message.}

\item{\code{queue}}{Object of class \code{StorageQueue}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueueMessage-delete"></a>}}
\if{latex}{\out{\hypertarget{method-QueueMessage-delete}{}}}
\subsection{Method \code{delete()}}{
Deletes this message from the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueueMessage$delete()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueueMessage-update"></a>}}
\if{latex}{\out{\hypertarget{method-QueueMessage-update}{}}}
\subsection{Method \code{update()}}{
Updates this message in the queue.

This operation can be used to continually extend the invisibility of a queue message. This functionality can be useful if you want a worker role to "lease" a message. For example, if a worker role calls \code{\link[=StorageQueue]{get_messages}} and recognizes that it needs more time to process a message, it can continually extend the message's invisibility until it is processed. If the worker role were to fail during processing, eventually the message would become visible again and another worker role could process it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueueMessage$update(visibility_timeout, text = self$text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{visibility_timeout}}{The new visibility timeout (time to when the message will again be visible).}

\item{\code{text}}{Optionally, new message text, either a raw or character vector. If a raw vector, it is base64-encoded, and if a character vector, it is collapsed into a single string before being sent to the queue.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The message object, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueueMessage-print"></a>}}
\if{latex}{\out{\hypertarget{method-QueueMessage-print}{}}}
\subsection{Method \code{print()}}{
Print method for this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueueMessage$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not currently used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The message object, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueueMessage-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QueueMessage-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueueMessage$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
