% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_predict.R
\name{classification_service}
\alias{classification_service}
\alias{customvision_predictive_service}
\alias{object_detection_service}
\title{Connect to a Custom Vision predictive service}
\usage{
classification_service(endpoint, project, name)

object_detection_service(endpoint, project, name)
}
\arguments{
\item{endpoint}{A prediction endpoint object, of class \code{customvision_prediction_endpoint}.}

\item{project}{The project underlying this predictive service. Can be either an object of class \code{customvision_project}, or a string giving the ID of the project.}

\item{name}{The published name of the service.}
}
\value{
An object of class \code{classification_service} or \code{object_detection_service}, as appropriate. These are subclasses of \code{customvision_predictive_service}.
}
\description{
Connect to a Custom Vision predictive service
}
\details{
These functions are handles to a predictive service that was previously published from a trained model. They have \code{predict} methods defined for them.
}
\examples{
\dontrun{

endp <- customvision_training_endpoint(url="endpoint_url", key="key")
myproj <- get_project(endp, "myproject")

# getting the ID from the project object -- in practice you would store the ID separately
pred_endp <- customvision_prediction_endpoint(url="endpoint_url", key="pred_key")
classification_service(pred_endp, myproj$project$id, "publishedname")

}
}
\seealso{
\code{\link{customvision_prediction_endpoint}}, \code{\link{customvision_project}}

\code{\link{predict.classification_service}}, \code{\link{predict.object_detection_service}}, \code{\link{do_prediction_op}}

\code{\link{train_model}}, \code{\link{publish_model}}
}
