% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BACCT.R
\docType{package}
\name{BACCT-package}
\alias{BACCT}
\alias{BACCT-package}
\title{Bayesian Augmented Control for Clinical Trials}
\description{
Implements the Bayesian Augmented Control (BAC, a.k.a. Bayesian historical data borrowing) method under clinical trial setting by calling 'Just Another Gibbs Sampler' ('JAGS') software. In addition, the 'BACCT' package evaluates user-specified decision rules by computing the type-I error/power, or probability of correct go/no-go decision at interim look. The evaluation can be presented numerically or graphically. Users need to have 'JAGS' 4.0.0 or newer installed due to a compatibility issue with 'rjags' package. Currently, the package implements the BAC method for binary outcome only. Support for continuous and survival endpoints will be added in future releases. We would like to thank AbbVie's Statistical Innovation group and Clinical Statistics group for their support in developing the 'BACCT' package.
}
\details{
JAGS software can be downloaded from \url{http://mcmc-jags.sourceforge.net/}.
}
\examples{
\dontrun{
library(BACCT)

#############################
#Example for binary response#
#############################

#specify historical data
yh = c(11,305,52);nh = c(45,874,120)
#specify subjects
n1 = 20;n2 = 30
#implement BAC and wait patiently
post = BAC_binom(yh=yh,nh=nh,n1=n1,n2=n2,n.chain=5,
       criterion.type="diff",sim.mode="express")
#evaluate the decision
rule1 = decision_eval(object=post,decision.rule=c(0.05,0.05),
        control.range=seq(0.3,0.5,0.01),es=c(0,0.1,0.15),csv.name="rule1.csv")
#plot the decision evaluation
(fig1 = plot(rule1))
#continue polishing the figure
#add data points
fig1 + geom_point(size=4)
#replace the title
fig1 + ggtitle("replace title")
#add reference lines
fig1 + geom_hline(aes(yintercept=0.05)) +
       geom_vline(aes(xintercept=0.42),color="black",type="dashed")
}

}
\references{
Viele, et al., "Use of historical control data for assessing
  treatment effects in clinical trials." Pharmaceutical statistics 13(1)
  (2014): 41-54.
}

