% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.arrangement}
\alias{kernel.arrangement}
\title{Functional arrangement of kernel density hypervolumes.}
\usage{
kernel.arrangement(
  comm,
  stat = "PNCP",
  distances = seq(0, 1, 0.01),
  type = "SES",
  alpha = 0.05,
  runs = 99,
  plot = TRUE
)
}
\arguments{
\item{comm}{A 'Hypervolume' object, built using function kernel.build.}

\item{stat}{statistic to be calculated. One of c("PNCP", "NNCP"), meaning
"cumulative proportion of pairwise neighbors" and "cumulative proportion of nearest neighbors", respectively.}

\item{distances}{vector of distances to be considered in calculations}

\item{type}{Envelope type for testing significance. One of c("ecdf", "norm", "SES"), meaning
"empirical cumulative distribution", "normalized envelope" (between 0-1, 0.5 indicate randomness,
more than 0.5 - clustered; less than 0.5 - inhibition), and "standardized effect size" respectively.}

\item{alpha}{alpha value to consider in significance testing (p-value).}

\item{runs}{number of simulations for significance testing}

\item{plot}{whether to plot the results}
}
\value{
A list with observed PNCP or NNCP values, a matrix of simulated values at r distances (r x sim), and standard effect size.
}
\description{
Functional arrangement of a community, measuring the distribution of species
within the total functional space at multiple spatial scales. This is a specific function
to be used with an Hypervolume object, preferably, from kernel.build function.
}
\details{
This function measures the functional arrangement (Carvalho & Cardoso, 2025)
of a n-dimensional hypervolume, namely the distribution of species within the total
trait space at multiple spatial scales.
}
\examples{
\dontrun{
comm = c(100,3,0,5,3)
names(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")

trait = data.frame(body = c(1,2,3,4,2), beak = c(1,5,4,1,2))
rownames(trait) = names(comm)

hv = kernel.build(comm, trait, method.hv = "svm", svm.nu = 0.01, svm.gamma = 0.25)
kernel.arrangement(hv)
}
}
\references{
Carvalho, J.C. & Cardoso, P. (2025) Quantifying species distribution within the functional space.
}
