% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEgeomBCD.R
\name{MLEgeomBCD}
\alias{MLEgeomBCD}
\title{Maximum Likelihood Estimation for a Bivariate Geometric Distribution via Conditional Specification}
\usage{
MLEgeomBCD(data, initial_values = c(0.5, 0.5, 0.5))
}
\arguments{
\item{data}{data frame or matrix with two columns, representing paired observations of count variables \eqn{(X, Y)}.}

\item{initial_values}{numeric vector of length 3 with initial values for the parameters \code{q1}, \code{q2}, and \code{q3}. Must be strictly between 0 and 1. Default is \code{c(0.5, 0.5, 0.5)}.}
}
\value{
A list containing:
\describe{
  \item{\code{q1}}{estimated q1.}
  \item{\code{q2}}{estimated q2.}
  \item{\code{q3}}{estimated q3.}
  \item{\code{logLik}}{Maximum log-likelihood achieved.}
  \item{\code{AIC}}{Akaike Information Criterion.}
  \item{\code{BIC}}{Bayesian Information Criterion.}
  \item{\code{convergence}}{Convergence status from the optimizer (0 means successful).}}
}
\description{
Estimates the parameters of a bivariate geometric distribution via Conditional Specification using maximum likelihood.
}
\details{
The model estimates parameters from a joint distribution for \eqn{(X, Y)} with the form:
\deqn{
P(X = x, Y = y) = K(q_1, q_2, q_3) q_1^x q_2^y q_3^{xy},
}
where \eqn{ K(q_1, q_2, q_3) } is the normalizing constant.
}
\examples{
# Simulate data
samples <- rgeomBCD(n = 50, q1 = 0.2, q2 = 0.2, q3 = 0.5)
result <-MLEgeomBCD(samples)
print(result)
# For better estimation accuracy and stability, consider increasing the sample size (n = 1000)

data(abortflights)
MLEgeomBCD(abortflights)

}
\references{
Ghosh, I., Marques, F., & Chakraborty, S.  (2023) A bivariate geometric distribution via conditional specification: properties and applications, Communications in Statistics - Simulation and Computation, 52:12, 5925--5945, \doi{10.1080/03610918.2021.2004419}
}
\seealso{
\code{\link{dgeomBCD}} \code{\link{pgeomBCD}} \code{\link{rgeomBCD}}
}
