% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHomTable.R
\name{getHomTable}
\alias{getHomTable}
\title{Get gene homologs between 2 organisms}
\usage{
getHomTable(
  from.org,
  to.org,
  from.source = "Ens_gene",
  to.source = from.source,
  restricted = TRUE,
  verbose = FALSE,
  recache = FALSE,
  filter = NULL,
  limForCache = 100
)
}
\arguments{
\item{from.org}{organism name}

\item{to.org}{organism name}

\item{from.source}{the from gene ID database}

\item{to.source}{the to gene ID database}

\item{restricted}{boolean indicating if the results should be restricted to
current version of to BEID db. If FALSE former BEID are also returned:
\strong{Depending on history it can take a very long time to return a very}
\strong{large result!}}

\item{verbose}{boolean indicating if the CQL query should be displayed}

\item{recache}{boolean indicating if the CQL query should be run even if
the table is already in cache}

\item{filter}{character vector on which to filter from IDs.
If NULL (default), the result is not filtered:
all from IDs are taken into account.}

\item{limForCache}{if there are more filter than limForCache results are
collected for all IDs (beyond provided ids) and cached for futur queries.
If not, results are collected only for provided ids and not cached.}
}
\value{
a data.frame mapping gene IDs with the
following fields:
\itemize{
\item \strong{from}: the from gene ID
\item \strong{to}: the to gene ID
}
}
\description{
Get gene homologs between 2 organisms
}
\examples{
\dontrun{
getHomTable(
   from.org="human",
   to.org="mouse"
)
}

}
\seealso{
\link{getBeIdConvTable}
}
