% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{bertopic_visualize_topics_per_class}
\alias{bertopic_visualize_topics_per_class}
\title{Visualize topics per class}
\usage{
bertopic_visualize_topics_per_class(
  model,
  topics_per_class,
  top_n_topics = 10L,
  topics = NULL,
  normalize_frequency = FALSE,
  custom_labels = FALSE,
  title = NULL,
  width = NULL,
  height = NULL,
  file = NULL
)
}
\arguments{
\item{model}{A "bertopic_r" model.}

\item{topics_per_class}{A data frame or Python object as returned by
\code{BERTopic.topics_per_class(docs, classes)}.}

\item{top_n_topics}{Integer; number of most frequent topics to display.}

\item{topics}{Optional integer vector of topic IDs to include.}

\item{normalize_frequency}{Logical; whether to normalize each topic's
frequency within classes.}

\item{custom_labels}{Logical or character scalar controlling label
behavior (forwarded to Python).}

\item{title}{Optional character plot title.}

\item{width, height}{Optional integer figure width/height in pixels.}

\item{file}{Optional HTML output path. If NULL, an \code{htmltools::HTML}
object is returned.}
}
\value{
If \code{file} is NULL, an \code{htmltools::HTML} object. Otherwise, the
normalized file path is returned invisibly.
}
\description{
Wrapper around Python \code{BERTopic.visualize_topics_per_class()}. This
visualizes how topics are distributed across a set of classes, using the
output of Python \code{topics_per_class(docs, classes)}.
}
