% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.default.R
\name{summary.explore}
\alias{summary.explore}
\title{Summary Method for \code{explore.default} Objects}
\usage{
\method{summary}{explore}(object, col_names = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{estimate}}

\item{col_names}{Logical. Should the summary include the column names (default is \code{TRUE})?
Setting to \code{FALSE} includes the column numbers (e.g., \code{1--2}).}

\item{...}{Currently ignored}
}
\value{
A dataframe containing the summarized posterior distributions.
}
\description{
Summarize the posterior distribution for each partial correlation
with the posterior mean and standard deviation.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

Y <- ptsd[,1:5]

fit <- explore(Y, iter = 250,
               progress = FALSE)

summ <- summary(fit)

summ
}
}
\seealso{
\code{\link{select.explore}}
}
