% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbvn.R
\name{cbvn}
\alias{cbvn}
\title{Fitting boundary line using censored bivariate normal model}
\usage{
cbvn(data,model="lp", equation=NULL, start, sigh, UpLo="U", optim.method="BFGS",
      Hessian=FALSE, plot=TRUE, line_smooth=1000, lwd=2, l_col="red",...)
}
\arguments{
\item{data}{A dataframe with two numeric columns, independent (\code{x}) and
dependent (\code{y}) variables respectively.}

\item{model}{Selects the functional form of the boundary line. It includes
\code{"blm"} for linear model, \code{"lp"} for linear plateau model, \code{"mit"}
for the Mitscherlich model, \code{"schmidt"} for the Schmidt model,
\code{"logistic"} for logistic model, \code{"logisticND"} for logistic model
proposed by Nelder (1961), \code{"inv-logistic"} for the inverse logistic model,
\code{"double-logistic"} for the double logistic model, \code{"qd"} for
quadratic model and the \code{"trapezium"} for the trapezium model. For custom
models, set \code{model = "other"}.}

\item{equation}{A custom model function writen in the form of an R function. Applies
only when argument \code{model="other"}, else it is \code{NULL}.}

\item{start}{A numeric vector of initial starting values for optimization
  in fitting the boundary model. Its length and arrangement depend on the
  suggested model: \itemize{
  \item For the \code{"blm"} model, it is a vector of length 7 arranged as the
  intercept, the slope, mean of \code{x}, mean of \code{y}, standard deviation
  of \code{x}, standard deviation of \code{y} and the correlation of \code{x}
  and \code{y}.
  \item For the \code{"lp"} model, it is a vector of length 8 arranged as the
  intercept, the slope, the maximum or plateau response, mean of \code{x},
  mean of \code{y}, standard deviation of \code{x}, standard deviation of \code{y}
  and the correlation of \code{x} and \code{y}.
  \item For the \code{"mit"} model, it is a vector of length 8 arranged as the
  intercept, shape parameter, the maximum or plateau response, mean of \code{x},
  mean of \code{y}, standard deviation of \code{x}, standard deviation of \code{y}
  and the correlation of \code{x} and \code{y}.
  \item For the \code{"logistic"}, \code{"inv-logistic"} and \code{"logisticND"}
  models, it is a vector of length 8 arranged as scaling parameter, shape parameter,
  the maximum or plateau value, mean of \code{x}, mean of \code{y},
  standard deviation of \code{x}, standard deviation of \code{y} and the
  correlation of \code{x} and \code{y}.
  \item For the \code{"double-logistic"} model, it is a vector of length 11
  arranged as scaling parameter, shape parameter, maximum response, maximum response,
  scaling parameter two, shape parameter two, mean of \code{x}, mean of \code{y},
  standard deviation of \code{x}, standard deviation of \code{y} and the correlation
  of \code{x} and \code{y}.
  \item For the \code{"trapezium"} model, it is a vector of length 10 arranged
  as intercept one, slope one, maximum response, intercept two, slope two,
  mean of \code{x}, mean of \code{y}, standard deviation of \code{x},
  standard deviation of \code{y} and the correlation of \code{x} and \code{y}.
  \item For the \code{"qd"} model, it is a vector of length 8 arranged as a
  constant, linear coefficient, quadratic coefficient,mean of \code{x},
  mean of \code{y}, standard deviation of \code{x}, standard deviation of \code{y}
  and the correlation of \code{x} and \code{y}.
  \item For the \code{"schmidt"} model, it is a vector of length 8 arranged the
  scaling parameter, shape parameter (x-value at maximum response ),
  maximum response, mean of \code{x}, mean of \code{y}, standard deviation of
  \code{x}, standard deviation of \code{y} and the correlation of \code{x}
  and \code{y}.
}}

\item{sigh}{Standard deviation of the measurement error.}

\item{UpLo}{Selects the type of boundary. \code{"U"} fits the upper boundary and
"L" fits the lower boundary.}

\item{optim.method}{Describes the method used to optimize the model as in the
\code{optim()} function. The methods include \code{"Nelder-Mead"}, \code{"BFGS"},
\code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"} and \code{"Brent"}.}

\item{Hessian}{If \code{True}, the hessian matrix is part of the output
(default is \code{FALSE}`).}

\item{plot}{If \code{TRUE}, a plot is part of the output. If \code{FALSE}, plot
is not part of output (default is \code{TRUE}).}

\item{line_smooth}{Parameter that describes the smoothness of the boundary line.
(default is 1000). The higher the value, the smoother the line.}

\item{lwd}{Determines the thickness of the boundary line on the plot (default is 1).}

\item{l_col}{Selects the color of the boundary line.}

\item{...}{Additional graphical parameters as in the \code{par()} function.}
}
\value{
A list of length 5 consisting of the fitted model, equation form,
  parameters of the boundary line, AIC (for boundary line model and a null model)
  and a hessian matrix.  Additionally, a graphical representation of the boundary
  line on the scatter plot is produced.
}
\description{
This function fits a response model to the upper limits  of a scatter plot of
of \code{x} and \code{y} to determine the most efficient response of \code{y}
as a function of \code{x} (given a measurement error of \code{y}) based on a
censored distribution (Milne et al., 2016). The location of censor in the data
cloud is determined based on the maximum likelihood approach. This is done using
optimization procedure and hence requires some starting guess parameters for the
proposed model. It then compares the results with an uncensored normal bivariate
distribution to access the appropriateness of the censored model.
}
\details{
Some inbuilt models are available for the \code{cbvn()} function. The suggest model
forms are as follows: \enumerate{
 \item Linear model (\code{"blm"})
 \deqn{y=\beta_1 + \beta_2x}
 where \eqn{\beta_1} is the intercept and \eqn{\beta_2} is the slope.

 \item Linear plateau model (\code{"lp"})
 \deqn{y= {\rm min}(\beta_1+\beta_2x, \beta_0)}
 where \eqn{\beta_1} is the intercept , \eqn{\beta_2} is the slope  and \eqn{\beta_0}
 is the maximum response.

 \item The logistic (\code{"logistic"}) and inverse logistic (\code{"inv-logistic"})
 models
 \deqn{ y= \frac{\beta_0}{1+e^{\beta_2(\beta_1-x)}}}
 \deqn{ y= \beta_0 - \frac{\beta_0}{1+e^{\beta_2(\beta_1-x)}}}
 where \eqn{\beta_1} is a scaling parameter , \eqn{\beta_2} is a shape parameter
 and \eqn{\beta_0} is the maximum response.

 \item Logistic model (\code{"logisticND"})  (Nelder (1961))
 \deqn{ y= \frac{\beta_0}{1+(\beta_1 \times e^{-\beta_2x})}}
  where \eqn{\beta_1} is a scaling parameter, \eqn{\beta_2} is a shape
  parameter and \eqn{\beta_0} is the maximum response.

 \item Double logistic model (\code{"double-logistic"})
 \deqn{ y= \frac{\beta_{0,1}}{1+e^{\beta_2(\beta_1-x)}} -
 \frac{\beta_{0,2}}{1+e^{\beta_4(\beta_3-x)}}}
 where \eqn{\beta_1} is a scaling parameter one, \eqn{\beta_2} is shape parameter one,
 \eqn{\beta_{0,1}} and \eqn{\beta_{0,2}} are the maximum response ,
 \eqn{\beta_3} is a scaling parameter two and  \eqn{\beta_4} is a shape parameter two.

 \item Quadratic model (\code{"qd"})
 \deqn{y=\beta_1 + \beta_2x + \beta_3x^2}
 where \eqn{\beta_1} is a constant, \eqn{\beta_2} is a linear coefficient
 and  \eqn{\beta_3} is the quadratic coefficient.

 \item Trapezium model (\code{"trapezium"})
 \deqn{y={\rm min}(\beta_1+\beta_2x, \beta_0, \beta_3 + \beta_4x)}
 where  \eqn{\beta_1} is the intercept one, \eqn{\beta_2} is the slope one,
 \eqn{\beta_0} is the maximum response, \eqn{\beta_3} is the intercept two
 and \eqn{\beta_3} is the slope two.

 \item Mitscherlich model (\code{"mit"})
 \deqn{y= \beta_0 - \beta_1*\beta_2^x}
 where \eqn{\beta_1} is the intercept, \eqn{\beta_2} is a shape parameter
 and \eqn{\beta_0} is the maximum response.

 \item Schmidt model (\code{"schmidt"})
 \deqn{y= \beta_0 + \beta_1(x-\beta_2)^2}
 where \eqn{\beta_1} is a scaling parameter, \eqn{\beta_2} is a
 shape parameter (x-value at maximum response ) and \eqn{\beta_0} is the
 maximum response .
 }

The function \code{cbvn()} utilities the optimization procedure of the
\code{optim()} function to determine the model parameters. There is a tendency
for optimization algorithms to settle at a local optimum. To remove the risk of
settling for local optimum parameters, it is advised that the function is run using
several starting values and the results with the smallest likelihood (or AIC)
can be taken as a representation of the global optimum.

The common errors encountered due to poor start values \enumerate{
\item function cannot be evaluated at initial parameters
\item initial value in 'vmmin' is not finite}
}
\examples{

x<-evapotranspiration$`ET(mm)`
y<-evapotranspiration$`yield(t/ha)`
data<-data.frame(x,y)
start<-c(0.5,0.02,289.6,2.4,83.7,1.07,0.287)

cbvn(data, start=start, model = "blm", sigh=0.51,
        xlab=expression("ET/ mm ha"^-1),
        ylab=expression("Yield/ ton ha"^-1),
        pch=16, col="grey", line_smooth = 100)

}
\references{
Nelder, J.A. 1961. The fitting of a generalization of the logistic curve.
Biometrics 17: 89–110.

Lark, R. M., & Milne, A. E. (2016). Boundary line analysis of the effect of water
filled pore space on nitrous oxide emission from cores of arable soil. European
Journal of Soil Science, 67 , 148-159.

Lark, R. M., Gillingham, V., Langton, D., & Marchant, B. P. (2020). Boundary line
models for soil nutrient concentrations and wheat yield in national-scale datasets.
European Journal of Soil Science, 71 , 334-351.

Milne, A. E., Ferguson, R. B., & Lark, R. M. (2006). Estimating a boundary line
model for a biological response by maximum likelihood.Annals of Applied Biology,
149, 223–234.

Phillips, B.F. & Campbell, N.A. 1968. A new method of fitting the von Bertelanffy
growth curve using data on the whelk. Dicathais, Growth 32: 317–329.

Schmidt, U., Thöni, H., & Kaupenjohann, M. (2000). Using a boundary line approach
to analyze N2O flux data from agricultural soils. Nutrient Cycling in Agroecosystems,
57, 119-129.
}
\author{
\enumerate{
\item Chawezi Miti \email{chawezi.miti@nottingham.ac.uk}
\item Richard Murray Lark \email{murray.lark@nottingham.ac.uk}
}
}
