# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title CHemical Equilibria in Soils and Solutions
#'
#' @description Given a chemical system, equilibria equations, and total
#'   concentrations of components, calculate the species concentrations of each
#'   chemical product in the system.
#'
#' @param QuietFlag character, one of "Very Quiet" (only print out when run is
#'   done), "Quiet" (print out Obs=iObs), or "Debug" (print out lots of info)
#' @param ConvergenceCriteria numeric, the maximum value of MaxError that 
#'   counts as convergence by the Newton-Raphson root-finding algorithm
#' @param MaxIter integer, the maximum number of iterations the Newton-Raphson
#'   root-finding algorithm should do before giving up
#' @param NMass integer, number of mass compartments
#' @param MassName CharacterVector (NMass), the names of the mass compartments
#' @param MassAmt NumericVector (NMass), The amount of each mass compartment. 
#' @param NComp integer, number of components
#' @param CompName character vector (NComp), the name of each component in the
#'   simulation
#' @param CompType character vector (NComp), the type of each component in the
#'   simulation
#' @param TotConc numeric vector (NComp), the total concentrations of each
#'   component in the simulation (units of e.g., mol/L and mol/kg)
#' @param NSpec integer, number of species reactions
#' @param SpecName character vector (NSpec), the name of the chemical species
#'   for which we have formation reactions
#' @param SpecType character vector (NSpec), the type or category of the 
#'   chemical species for which we have formation reactions.
#' @param SpecMCR IntegerVector (NSpec), the mass compartment of the chemical
#'   species for which we have formation reactions
#' @param SpecK numeric vector (NSpec), the equilibrium coefficient of the
#'   formation reactions.
#' @param SpecTempKelvin NumericVector (NSpec), the temperature associated with
#'   K/logK and DeltaH of the formation reactions 
#' @param SpecDeltaH numeric vector (NSpec), the enthalpy change of the
#'   formation reactions
#' @param SpecStoich signed integer matrix (NSpec x NComp), the reaction
#'   stoichiometry of the formation reactions
#' @param SpecCharge signed integer vector (NSpec), the charge of the chemical
#'   species for which we have formation reactions
#' @param SpecActCorr character vector (NSpec), the activity correction method
#'   of the chemical species for which we have formation reactions
#' @param DoWHAM boolean, true=there are WHAM species, false=no WHAM species
#' @param AqueousMCR integer, the (1-based) position of the water/aqueous mass
#'   compartment. (transformed to 0-based at the beginning of the function)
#' @param WHAMDonnanMCR the mass compartments corresponding to the
#'   humic acid (0) and fulvic acid (1) Donnan layers. (transformed to 0-based
#'   at the beginning of the function)
#' @param HumicSubstGramsPerLiter NumericVector, length of 2, grams per liter 
#'   of each organic matter component (HA and FA) in solution
#' @param WHAMMolWt numeric (2), WHAM's molecular weight parameter for organic
#'   matter
#' @param WHAMRadius numeric (2), WHAM's molecular radius parameter for organic
#'   matter
#' @param WHAMP numeric (2), WHAM's P parameter...
#' @param WHAMDLF numeric (2), WHAM's Double layer overlap factor
#' @param WHAMKZED numeric (2), WHAM's Constant to control DDL at low ZED
#' @param SysTempKelvin double; input temperature for the current observation,
#'   in Kelvin
#' @param DoTox logical, TRUE for toxicity mode where the MetalName component
#'   concentration is adjusted to try to match the CATarget with BLMetalSpecs
#' @param MetalName character string, the name of the toxic metal
#' @param MetalCompR integer, the position of the metal in the component arrays
#'   (i.e., which is the toxic metal component) Note: this is base-1 indexed on
#'   input then converted.
#' @param BLCompR integer, the position of the biotic ligand in the component 
#'   arrays. Note: this is base-1 indexed on input, then converted.
#' @param NBLMetal integer, the number of biotic ligand-bound metal species 
#'   that are associated with toxic effects.
#' @param BLMetalSpecsR integer vector, the positions of the species in the
#'   arrays which contribute to toxicity (i.e., which species are the toxic
#'   metal bound to the relevant biotic ligand) Note: these are base-1 indexed
#'   on input then converted.
#' @param CATarget numeric, the target critical accumulation in units of mol /
#'   kg (only used when DoTox == TRUE)
#' @param DodVidCj boolean, should the Jacobian matrix include the change in
#'   the main water solution (excluding Donnan layer volume)?
#' @param DodVidCjDonnan boolean, should the Jacobian matrix include the change
#'   in the Donnan layer volume?
#' @param DodKidCj boolean, should the Jacobian matrix include the change in
#'   the DOC equilibrium constants?
#' @param DoGammai boolean, should the Jacobian matrix include the change in 
#'   the activity coefficients?
#' @param DoJacDonnan boolean, should the Jacobian matrix be used to solve the
#'   Donnan layer concentrations?
#' @param DoJacWHAM boolean, should the Jacobian matrix be used to solve the
#'   WHAM component concentrations?
#' @param DoWHAMSimpleAdjust boolean, should SimpleAdjust be used to solve the
#'   WHAM component concentrations?
#' @param DoDonnanSimpleAdjust boolean, should SimpleAdjust be used to solve
#'   the Donnan layer concentrations?
#'
#' @return list with the following elements:
#' \describe{
#'   \item{SpecConc}{numeric vector (NSpec), the concentrations of each species
#'     for which we have formation reactions}
#'   \item{FinalIter}{integer, the number of Newton-Raphson iterations that we
#'     needed to reach convergence}
#'   \item{FinalMaxError}{numeric, the highest final absolute error fraction  
#'     =max(abs(Resid / TotMoles))}
#'   \item{CalcTotConc}{numeric vector (NComp), the calculated total
#'     concentrations of each component in the simulation (units of e.g., mol/L
#'     and mol/kg)}
#' }
#' @export
#'
CHESS <- function(QuietFlag, ConvergenceCriteria, MaxIter, NMass, MassName, MassAmt, NComp, CompName, CompType, TotConc, NSpec, SpecName, SpecType, SpecMCR, SpecK, SpecTempKelvin, SpecDeltaH, SpecStoich, SpecCharge, SpecActCorr, DoWHAM, AqueousMCR, WHAMDonnanMCR, HumicSubstGramsPerLiter, WHAMMolWt, WHAMRadius, WHAMP, WHAMDLF, WHAMKZED, SysTempKelvin, DoTox, MetalName, MetalCompR, BLCompR, NBLMetal, BLMetalSpecsR, CATarget, DodVidCj, DodVidCjDonnan, DodKidCj, DoGammai, DoJacDonnan, DoJacWHAM, DoWHAMSimpleAdjust, DoDonnanSimpleAdjust) {
    .Call(`_BLMEngineInR_CHESS`, QuietFlag, ConvergenceCriteria, MaxIter, NMass, MassName, MassAmt, NComp, CompName, CompType, TotConc, NSpec, SpecName, SpecType, SpecMCR, SpecK, SpecTempKelvin, SpecDeltaH, SpecStoich, SpecCharge, SpecActCorr, DoWHAM, AqueousMCR, WHAMDonnanMCR, HumicSubstGramsPerLiter, WHAMMolWt, WHAMRadius, WHAMP, WHAMDLF, WHAMKZED, SysTempKelvin, DoTox, MetalName, MetalCompR, BLCompR, NBLMetal, BLMetalSpecsR, CATarget, DodVidCj, DodVidCjDonnan, DodKidCj, DoGammai, DoJacDonnan, DoJacWHAM, DoWHAMSimpleAdjust, DoDonnanSimpleAdjust)
}

