% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CriticalValues.R
\name{CriticalValues}
\alias{CriticalValues}
\alias{AddCriticalValues}
\alias{RemoveCriticalValues}
\title{Edit Critical Values Table}
\usage{
AddCriticalValues(
  ThisProblem,
  CATab = data.frame(),
  CA = CATab[, which(colnames(CATab) \%in\% c("CA", "CA (nmol/gw)"))[1]],
  Species = CATab$Species,
  TestType = CATab[, which(colnames(CATab) \%in\% c("TestType", "Test.Type",
    "Test Type"))[1]],
  Duration = CATab$Duration,
  Lifestage = CATab$Lifestage,
  Endpoint = CATab$Endpoint,
  Quantifier = CATab$Quantifier,
  References = CATab$References,
  Miscellaneous = CATab$Miscellaneous,
  DoCheck = TRUE
)

RemoveCriticalValues(ThisProblem, CAToRemove, DoCheck = TRUE)
}
\arguments{
\item{ThisProblem}{A list object with a structure like that returned by
`BlankProblem()`.}

\item{CATab}{a data.frame object with, at a minimum, columns named
`CA`/`CA (nmol/gw)`, `Species`, `TestType`/`Test.Type`/`Test Type`,
`Duration`, `Lifestage`, `Endpoint`, `Quantifier`, `References`,
`Miscellaneous`. See optional parameter descriptions for further
descriptions of each of those columns.}

\item{CA}{(optional) a numeric vector of the critical accumulation value(s)
in nmol/gw.}

\item{Species}{(optional) a character vector of the species names to include
for the corresponding `CA` value.}

\item{TestType}{(optional) a character vector of the test type (e.g., "Acute"
or "Chronic") to include for the corresponding `CA` value.}

\item{Duration}{(optional) a character vector of the Duration to include for
the corresponding `CA` value. Can also be `"DIV=#.##"` for FAV, FCV, WQS,
and HC5 critical values.}

\item{Lifestage}{(optional) a character vector of the organism Lifestage to
include for the corresponding `CA` value. Can also be `"ACR=#.##"` for FAV,
WQS, and HC5 critical values.}

\item{Endpoint}{(optional) a character vector of the Endpoint to include for
the corresponding `CA` value. This can also be either `"FAV"`, `"FCV"`,
`"HC5"`, `"WQS"`, `"CMC"`, or `"CCC"` to indicate this critical value
calculates one of those water quality standards.}

\item{Quantifier}{(optional) a character vector of the Quantifier (e.g.,
EC50, NOEC, ...) to include for the corresponding `CA` value. May also be
`NA` if this is a WQS value.}

\item{References}{(optional) a character vector of the list of References to
include for the corresponding `CA` value. Each `CA` value requires a single
character string with no line breaks.}

\item{Miscellaneous}{(optional) a character vector of the miscellaneous
information (e.g., how the value was calculated, test conditions not
covered by other columns, etc.) to include for the corresponding `CA`
value.}

\item{DoCheck}{A logical value indicating whether checks should be performed
on the incoming and outgoing problem objects. Defaults to `TRUE`, as you
usually want to make sure something isn't awry, but the value is often set
to `FALSE` when used internally (like in DefineProblem) so the problem is
only checked once at the end.}

\item{CAToRemove}{an integer vector - the indices/row numbers of the critical
values to remove from the table.}
}
\value{
The edited version of `ThisProblem`.
}
\description{
`AddCriticalValues` will add one or more rows to the critical
  accumulation table (CAT or CATab), while `RemoveCriticalValues` will remove
  one or more rows,
}
\examples{
my_new_problem = carbonate_system_problem

my_new_problem = AddCriticalValues(
  ThisProblem = my_new_problem,
  CA = 12345,
  Species = "A. species",
  TestType = "Acute",
  Duration = "24h",
  Lifestage = "adult",
  Endpoint = "survival",
  Quantifier = "LC50",
  References = "thin air",
  Miscellaneous = "individual data point"
)

lots_of_data = data.frame(CA = runif(26),
                          Species = paste0(LETTERS,". species"),
                          TestType = "Acute",
                          Duration = "24h",
                          Lifestage = "adult",
                          Endpoint = "survival",
                          Quantifier = "LC50",
                          References = "thin air")
my_new_problem = AddCriticalValues(
  ThisProblem = my_new_problem,
  CATab = lots_of_data
)

my_new_problem = RemoveCriticalValues(
  ThisProblem = my_new_problem,
  CAToRemove = which((my_new_problem$CATab$Species == "A. species") &
                       is.na(my_new_problem$CATab$Miscellaneous))
)

print(my_new_problem$CATab)

}
\seealso{
Other problem manipulation functions: 
\code{\link{BlankProblem}()},
\code{\link{Components}},
\code{\link{InLabs}},
\code{\link{InVars}},
\code{\link{MassCompartments}},
\code{\link{Phases}},
\code{\link{SpecialDefs}},
\code{\link{Species}}
}
\concept{problem manipulation functions}
