% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lpz_distNODE}
\alias{lpz_distNODE}
\title{lpz_dist optimized for individual updates}
\usage{
lpz_distNODE(Z, node, diag)
}
\arguments{
\item{Z}{Latent positions matrix}

\item{node}{Specific node in the network corresponding to the latent coordinate which will be used as reference}

\item{diag}{Diagonal from \code{t(Z)\%*\%Z} matrix, passed to speed up the process.}
}
\value{
Vector containing the negative square root of the Euclidean distances between latent positions
}
\description{
Compute the square root of the Euclidean distances between a specific coordinate in the latent space
and all the others. The function follows almost the same approach as \link[BLSM]{lpz_dist}, but it is
more suitable for the individual updates occurring during the simulation.
}
