% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coprimary_endpoint.R
\name{get_boundary_oc_coprimary}
\alias{get_boundary_oc_coprimary}
\title{Computes both the boundary and corresponding operating characteristics for co primary endpoints}
\usage{
get_boundary_oc_coprimary(
  H0,
  H1,
  n,
  nsim,
  lambda,
  gamma,
  eta = NULL,
  method = "power",
  seed = NULL
)
}
\arguments{
\item{H0}{A numeric vector representing the null response rates for different outcomes, specified in the following order:
- `H0[1]`: Response - PFS6,
- `H0[2]`: Response - no PFS6,
- `H0[3]`: No Response - PFS6,
- `H0[4]`: No Response - no PFS6}

\item{H1}{A numeric vector representing the null response rates for different outcomes, specified in the following order:
- `H1[1]`: Response - PFS6,
- `H1[2]`: Response - no PFS6,
- `H1[3]`: No Response - PFS6,
- `H1[4]`: No Response - no PFS6}

\item{n}{A numeric vector representing the additional patients enrolled at each interim analysis.
The value at index \code{i} indicates the number of new patients added at interim analysis \code{i}. 
The total sample size at interim \code{i} is the cumulative sum of the values in \code{n} up to that index. 
For example, for four interim analyses with total sample sizes of 10, 15, 20, and 30, 
the vector would be represented as \code{n = c(10, 5, 5, 10)}, where:
\itemize{
  \item 10 is the number of patients enrolled at interim 1,
  \item 5 (15 - 10) is the additional number of patients enrolled at interim 2,
  \item 5 (20 - 15) is the additional number of patients enrolled at interim 3,
  \item 10 (30 - 20) is the additional number of patients enrolled at interim 4.
}}

\item{nsim}{number of simulation. A value at least 1000 for better result}

\item{lambda}{A vector of values for parameter `lambda` of the cut-off probability (i.e common for both efficacy and futility cut-off probability)}

\item{gamma}{A vector of values for parameter `gamma` of the cut-off probability for futility}

\item{eta}{A vector of values for parameter `eta` of the cut-off probability for efficacy}

\item{method}{A character string specifying the method to use for calculating cutoff values for the efficacy stopping.
Options are "power" (default) or "OF" for "O'Brien-Fleming".}

\item{seed}{for reproducibility}
}
\value{
A data frame with the following columns
\describe{
\item{fut_boundary_resp_i: }{Futility boundary for response at the ith analysis}
\item{fut_boundary_tox_i: }{Futility boundary for toxicity at the ith analysis}
\item{sup_boundary_resp_i: }{Superiority boundary for response at the ith analysis}
\item{sup_boundary_tox_i: }{Superiority boundary for toxicity at the ith analysis}
\item{earlystopfuti_mean_h0: }{Average number of early stopping due to futility under the null hypothesis}
 \item{earlystopsupe_mean_h0: }{Average number of early stopping for futility due to efficacy under the null hypothesis}
  \item{ss_mean_h0: }{Average sample size under the null hypothesis} 
  \item{rejectnull_mean_h0: }{Average number of hypothesis rejection at the final analysis under the null hypothesis} 
  \item{earlystopfuti_mean_h1: }{Average number of early stopping due to futility under the alternative hypothesis} 
  \item{earlystopsupe_mean_h1: }{Average number of early early stopping due to efficacy under the alternative hypothesis} 
  \item{ss_mean_h1: }{Average sample size under the alternative hypothesis} 
  \item{rejectnull_mean_h1: }{Average number of hypothesis rejection at the final analysis under the alternative hypothesis} 
  \item{lambda: }{lambda values for cut-off probability}
  \item{gamma: }{gamma values for cut-off probability}
  \item{eta: }{eta values for cut-off probability}}
}
\description{
Computes both the boundary and corresponding operating characteristics for co primary endpoints
}
\examples{
oc_coprimary<-get_boundary_oc_coprimary(
  H0=c(0.15,0.30, 0.15, 0.40), 
  H1= c(0.18,0.42, 0.02, 0.38),
  n = c(10, 5, 5),
  nsim = 1000,
  lambda = seq(0, 1, l = 11),
  gamma  = seq(0, 1, l = 11),
  eta    = seq(0, 3, l = 31),
  method = "power",
  seed = 1
)

}
\keyword{internal}
