% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Rural}
\alias{Rural}
\title{Social adjustment scores for a rural group and a city group of children}
\format{
A data frame/tibble with 33 observations on two variables
\describe{ 
\item{score}{child's social adjustment score} 
\item{area}{character variable with values \code{city} and \code{rural}} 
}
}
\usage{
Rural
}
\description{
Data for Example 7.16
}
\examples{

boxplot(score ~ area, data = Rural)
wilcox.test(score ~ area, data = Rural)
\dontrun{
library(dplyr)
Rural <- dplyr::mutate(Rural, r = rank(score))
Rural
t.test(r ~ area, data = Rural)
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
