% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.DCMB}
\alias{summary.DCMB}
\title{Summary function for objects of class DCMB}
\usage{
\method{summary}{DCMB}(x,...)
}
\arguments{
\item{x}{object of class DCMB}

\item{...}{additional parameters to pass on to the function}
}
\value{
returns a table of summary values
}
\description{
Gives out a summary of the posterior samples for parameters of any of the models, outputs of which are contained in a DCMB object
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
res3 <- BSTZINB(y, X, A, LinearT=TRUE, nchain=3, niter=100, nburn=20, nthin=1)
summary(res3)
}

}
