% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{names.TidySet}
\alias{names.TidySet}
\title{Names of a TidySet}
\usage{
\method{names}{TidySet}(x)
}
\arguments{
\item{x}{A TidySet object.}
}
\value{
A vector with the names of the present columns of the sets, elements and
relations.
If a slot is active it only returns the names of that slot.
}
\description{
Retrieve the column names of a slots of a TidySet.
}
\examples{
relations <- data.frame(
    sets = c(rep("a", 5), "b"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
TS <- tidySet(relations)
names(TS)
names(activate(TS, "sets"))
}
\seealso{
\code{\link[=dimnames]{dimnames()}}
}
