% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rename.R
\name{rename_set}
\alias{rename_set}
\alias{rename_set,TidySet-method}
\title{Rename sets}
\usage{
rename_set(object, old, new)

\S4method{rename_set}{TidySet}(object, old, new)
}
\arguments{
\item{object}{A TidySet object.}

\item{old}{A character vector of to be renamed.}

\item{new}{A character vector of with new names.}
}
\value{
A \code{TidySet} object.
}
\description{
Change the default names of sets and elements.
}
\section{Methods (by class)}{
\itemize{
\item \code{rename_set(TidySet)}: Rename sets

}}
\examples{
x <- list("A" = letters[1:5], "B" = letters[3:7])
TS <- tidySet(x)
name_sets(TS)
TS2 <- rename_set(TS, "A", "C")
name_sets(TS2)
}
\seealso{
\code{\link[=name_sets]{name_sets()}}

Other renames: 
\code{\link{rename_elements}()}

Other names: 
\code{\link{name_elements}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{rename_elements}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{group_by.TidySet}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
\concept{names}
\concept{renames}
