% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.Q.bwer.R
\name{get.Q.bwer}
\alias{get.Q.bwer}
\title{Get Efficacy Cutoff based on Basket-Wise Error Rate (BWER) Control}
\usage{
get.Q.bwer(object, alpha = 0.1, digits = 3, Qclust = NULL)
}
\arguments{
\item{object}{returned by \link{post.infer}.}

\item{alpha}{basket-wise type I error control.}

\item{digits}{number of digits in the cutoffs.}

\item{Qclust}{\code{NULL} means all cutoffs are different; If there are B=5 baskets and
\code{Qclust=(1,1,2,2,2)}, it means cutoffs for the first two baskets will be the same
and another cutoff will be tuned separately for baskets 3-5.}
}
\value{
It returns the efficacy cutoffs.
}
\description{
Get Efficacy Cutoff based on Basket-Wise Error Rate (BWER) Control
}
\examples{
N <- rbind(
c(10, 25),
c(10, 25),
c(10, 25),
c(10, 25),
c(10, 25)) # interim sample size and total sample size for each indication
scenarios <- rbind( c(0.15, 0.15, 0.15, 0.15, 0.15), c(0.3, 0.3, 0.3, 0.3, 0.3) )
res <- generate.data(N = N, ORRs = scenarios, ntrial = 1000, seed = 343809)
post <- post.infer(res, pnull = rep(0.15,5), stopbounds = cbind(c(1,1,1,1,1)),
ModelFit = "localPP", method = "PEB", a = 2, delta = 0.3)
(Q <- get.Q.bwer(post, alpha = 0.1, digits = 3, Qclust = rep(1, 5)))
Qmat <- array(NA, dim = dim(post$postprob))
for(i in 1:5) Qmat[,,i] <- Q[i]
apply(post$postprob>Qmat, c(1,3), mean)
}
