% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MDSmap.R
\name{plot.MDSmap}
\alias{plot.MDSmap}
\title{Draws two-dimensional plots for multidimensional scaling (MDS) from a 'MDSmap' object}
\usage{
\method{plot}{MDSmap}(
  x,
  z.var = NULL,
  level.plot = TRUE,
  title = NULL,
  labels = NULL,
  repel_labels = FALSE,
  text_label = TRUE,
  label_size = 3,
  subset = NULL,
  col.subset = "gray50",
  zoom = NULL,
  palette = NULL,
  contour = FALSE,
  ncol.arrange = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{MDSmap}.}

\item{z.var}{character vector; defines the set of variables (available in the \code{data} data frame of \code{\link{MDSmap}}) used to color-coding the points in the map (for scatter plots) or, alternatively, overlap to the map a colored level plot.}

\item{level.plot}{logical; if TRUE, draws a level plot, otherwise draws a scatter plot (not active if \code{zvar=NULL}).}

\item{title}{character, plot title.}

\item{labels}{character vector, labels for (x, y) points (only for single scatter plot).}

\item{repel_labels}{logical; if \code{TRUE}, draw text labels using repelling (not for highlighted points) (see \code{\link[ggrepel]{geom_text_repel}}).}

\item{text_label}{logical; if \code{TRUE}, draw a rectangle behind the text labels (not active if \code{subset=NULL}).}

\item{label_size}{numeric;  label font size (default \code{label_size=3}, for scatter plots).}

\item{subset}{logical vector, to select a subset of points to be highlighted.}

\item{col.subset}{character, color for the subset of points.}

\item{zoom}{numeric vector with 4 elements; \code{c(xmin,xmax,ymin,ymax)} for the x- and y-axis limits of the plot.}

\item{palette}{color palette.}

\item{contour}{logical; if \code{TRUE}, contour lines are plotted (not active if \code{level.plot=FALSE}).}

\item{ncol.arrange}{integer, number of columns when arranging multiple grobs on a page.}

\item{...}{other graphical parameters.}
}
\value{
A single \code{ggplot2} plot or a list of \code{ggplot2} plots
}
\description{
Draws two-dimensional plots for multidimensional scaling (MDS) from a 'MDSmap' object
}
\examples{
data <- data.frame(Pbox$PTS, Pbox$P3M, Pbox$P2M, Pbox$OREB + Pbox$DREB, Pbox$AST,
Pbox$TOV,Pbox$STL, Pbox$BLK)
names(data) <- c('PTS','P3M','P2M','REB','AST','TOV','STL','BLK')
selp <- which(Pbox$MIN >= 1500)
data <- data[selp,]
id <- Pbox$Player[selp]
mds <- MDSmap(data)
plot(mds, labels=id, z.var="P2M", level.plot=FALSE, palette=rainbow)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{MDSmap}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
