## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

#install.packages("BayesAT")
#install.packages("reportRmd")
library("BayesAT")
set.seed(1)
 

## -----------------------------------------------------------------------------
data <- Simulate_Enroll(n = 100,
                        lambda = 0.03,
                        event = 0.1,
                        M = 1,
                        group = 5,
                        maxt = 5,
                        accrual = 3,
                        censor = 0.9,
                        followup = 2,
                        partition = "Even")

## -----------------------------------------------------------------------------

test <- Bayes_test(data, 
                   alpha = 3, 
                   beta = 20, 
                   test = "less",  
                   threshold = 0.03, 
                   type = "Posterior",
                   diagnosis = FALSE)

summary(test)

## -----------------------------------------------------------------------------

test <- Bayes_test(data, 
                   alpha = 3, 
                   beta = 20, 
                   test = "greater", 
                   pred = 2, 
                   threshold = 0.03, 
                   type = "Posterior",
                   diagnosis = FALSE)
summary(test)

## -----------------------------------------------------------------------------

test <- Bayes_test(data, 
                   alpha = 3, 
                   beta = 60, 
                   test = "greater", 
                   pred = 2, 
                   threshold = 0.9, 
                   type = "Predictive",
                   diagnosis = TRUE)
summary(test)

## -----------------------------------------------------------------------------
data <- Simulate_Enroll(n = c(17,23,16,24,15,25),
                        lambda = 0.025,
                        event = 0.05,
                        M = 4,
                        group = 6,
                        maxt = 4,
                        accrual = 3,
                        censor = 0.95,
                        followup = 1,
                        partition = "Uneven")

head(data[[1]])

## -----------------------------------------------------------------------------
IA <- BayesAT(data,
              D = 3,
              stage = 7,
              threshold = 0.89, 
              start = 1.5,
              objective = 2,
              alpha = 2, 
              beta = 20)
summary(IA)
plot(IA)

