% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_nuisIC.R
\name{rm_nuisIC}
\alias{rm_nuisIC}
\title{Remove nuisance ICs from data}
\usage{
rm_nuisIC(
  BOLD,
  DR = NULL,
  prior_mean = NULL,
  Q2 = NULL,
  Q2_max = NULL,
  checkRowCenter = TRUE,
  verbose = FALSE,
  return_Q2 = FALSE
)
}
\arguments{
\item{BOLD}{the row-centered \eqn{V} by \eqn{T} data}

\item{DR, prior_mean}{We need an initial estimate of the brain networks, so
that we can avoid removing them during removal of the estimated noise ICs.
Provide either \code{DR} if dual regression has already been calculated, or
\code{prior_mean} (in this context, equivalent to a template result) if it
hasn't. Exactly one must be provided.}

\item{Q2}{The number of nuisance ICs. If \code{NULL} (default) will estimate
using PESEL.}

\item{Q2_max}{If \code{Q2} is \code{NULL}, PESEL's estimate will be less than
or equal to \code{Q2_max}. If \code{Q2_max} is \code{NULL} (default), do not
limit PESEL's estimate.}

\item{checkRowCenter}{Check row means, and raise an error if they are
nonzero? Default: \code{TRUE}.}

\item{verbose}{If \code{TRUE}, display progress updates.}

\item{return_Q2}{Return (estimated) \code{Q2} too? Default: \code{FALSE}.}
}
\value{
The \eqn{V} by \eqn{T} data with the estimated nuisance ICs
subtracted from it. If \code{return_Q2}, a list of length two: the second
entry will be \code{Q2}.
}
\description{
Subtract estimated nuisance ICs from data matrix. If the number of
nuisance ICs is not provided, will estimate using PESEL (the nuisance ICs
are a rotation of the nuisance PCs).
}
\keyword{internal}
