#' Compute the mode of a numerical vector
#' @param x A vector with numbers
#' @returns
#' `Mode` returns a value representing the most frequent numerical value in the vector `x`
#' @examples
#' # Finding the mode of a vector of numbers
#' x <- c(1, 2, 2, 3, 5, 8, 10)
#' Mode(x)
#' @export
Mode <- function(x) {
  ux <- unique(x)
  ux[which.max(tabulate(match(x, ux)))]
}
