% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postalpha0.R
\name{postalpha0}
\alias{postalpha0}
\title{Posterior for alpha0}
\usage{
postalpha0(alpha0, a, b, N, cluster)
}
\arguments{
\item{alpha0}{A scalar defining the parameter for the Dirichlet process prior
that controls the number of clusters (or its initial values)}

\item{a}{The hyperparameter value for the shape parameter in the gamma prior for alpha0}

\item{b}{The hyperparameter value for the scale parameter in the gamma prior for alpha0}

\item{N}{A scalar representing the number of data sequences}

\item{cluster}{A vector containing the cluster assignments for the data sequences (or its initial values)}
}
\value{
A numerical value corresponding to a sample from the posterior of alpha0
}
\description{
Posterior for alpha0
}
\note{
This function is called within the Gibbs sampler, but it can be called seperately.
}
\examples{
postalpha0(alpha0 = 1/100, a = 2, b = 1000, N = 5, cluster = c(1,1,2,1,1))

}
