% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneSampleNormal1.Design.R
\name{OneSampleNormal1.Design}
\alias{OneSampleNormal1.Design}
\title{One sample Normal model with one-parameter unknown, given variance}
\usage{
OneSampleNormal1.Design(
  prior,
  nmin = 10,
  nmax = 100,
  mu0,
  mu1,
  var,
  d = 0,
  ps,
  pf,
  power = 0.8,
  t1error = 0.05,
  alternative = c("less", "greater"),
  seed = 202209,
  sim = 1000
)
}
\arguments{
\item{prior}{A list of length 2 containing the distributional information of the prior.
The first element is a number specifying the type of prior. Options are
\enumerate{
\item DIP ;
\item Normal(mu0,var/n0), where mu0 = prior mean, var = the known variance}
The second elements of the list is the parameter n0.}

\item{nmin}{The start searching sample size}

\item{nmax}{The stop searching sample size}

\item{mu0}{The null mean value, which could be taken as the standard or current mean.}

\item{mu1}{The mean value of the new treatment.}

\item{var}{The variance}

\item{d}{The target improvement (minimal clinically meaningful difference).}

\item{ps}{The efficacy boundary (upper boundary).}

\item{pf}{The futility boundary (lower boundary).}

\item{power}{The power to achieve.}

\item{t1error}{The controlled type-I-error.}

\item{alternative}{less (lower values imply greater efficacy) or greater (larger
values imply greater efficacy).}

\item{seed}{The seed for simulations.}

\item{sim}{The number of simulations.}
}
\value{
A list of the arguments with method and computed elements.
}
\description{
#' Calculate the minimum planned sample size under an admissible design.
The users decide the power and type-I-error, and pick the efficacy and futility boundaries.
If there are no admissible design based on controlled type-I-error, then default to output
the designs with the lowest type-I-error and at least the user-defined (e.g. 80\%) power.
}
\examples{
\donttest{
# with traditional Bayesian prior Beta(1,1)
OneSampleNormal1.Design(list(2,6), nmin = 10, nmax = 100, mu0 = 100, mu1 = 95, var=15, d = 0.05,
                  ps = 0.95, pf = 0.05, power = 0.8, t1error = 0.05, alternative = "less",
                  seed = 202210, sim = 10)
# with DIP
OneSampleNormal1.Design(list(1,0), nmin = 10, nmax = 100, mu0 = 100, mu1 = 95, var=15, d = 0.05,
                  ps = 0.95, pf = 0.05, power = 0.8, t1error = 0.05, alternative = "less",
                  seed = 202210, sim = 10)
}
}
