% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LN_mean.R
\name{LN_MeanReg}
\alias{LN_MeanReg}
\title{Bayesian Estimate of the conditional Log-normal Mean}
\source{
Fabrizi, E., & Trivisano, C. \emph{Bayesian Conditional Mean Estimation in Log-Normal Linear Regression Models with Finite
Quadratic Expected Loss.} Scandinavian Journal of Statistics, 43(4), 1064-1077. (2016).
}
\usage{
LN_MeanReg(
  y,
  X,
  Xtilde,
  method = "weak_inf",
  y_transf = TRUE,
  h = NULL,
  CI = TRUE,
  alpha_CI = 0.05,
  type_CI = "two-sided",
  nrep = 1e+05
)
}
\arguments{
\item{y}{Vector of observations of the response variable.}

\item{X}{Design matrix.}

\item{Xtilde}{Matrix of covariate patterns for which an estimate is required.}

\item{method}{String that indicates the prior setting to adopt. Choosing \code{"weak_inf"} a weakly
informative prior setting is adopted, whereas selecting
\code{"optimal"} the hyperparameters are aimed at minimizing the frequentist MSE.}

\item{y_transf}{Logical. If \code{TRUE}, the \code{y} vector is already assumed as log-transformed.}

\item{h}{Leverage. With the default option \code{NULL}, the average leverage is used.}

\item{CI}{Logical. With the default choice \code{TRUE}, the posterior credibility interval is computed.}

\item{alpha_CI}{Level of alpha that determines the credibility (1-\code{alpha_CI}) of the posterior interval.}

\item{type_CI}{String that indicates the type of interval to compute: \code{"two-sided"} (default),
\code{"UCL"} (i.e. Upper Credible Limit) for upper one-sided intervals  or \code{"LCL"} (i.e. Lower
Credible Limit) for lower one-sided intervals.}

\item{nrep}{Number of simulations.}
}
\value{
The function returns a list including the prior and posterior parameters, the point estimate of the log-normal mean conditioned with respect to the covariate
points included in \code{Xtilde}. It consists of the mean of the posterior
distribution for the functional \eqn{\exp\{\tilde{x}_i^T\beta+\sigma^2/2\}} and the posterior variance.
}
\description{
This function produces a bayesian estimate of the conditional log-normal mean assuming a GIG prior for the variance and an
improper prior for the regression coefficients of the linear regression in the log scale.
}
\details{
In this function the same procedure as \link{LN_Mean} is implemented allowing for the inclusion of covariates.
Bayesian point and interval estimates for the response variabile in the original scale are provided considering the model:
\eqn{log(y_i)=X\beta}.
}
\examples{
library(BayesLN)
data("fatigue")

# Design matrices
Xtot <- cbind(1, log(fatigue$stress), log(fatigue$stress)^2)
X <- Xtot[-c(1,13,22),]
y <- fatigue$cycle[-c(1,13,22)]
Xtilde <- Xtot[c(1,13,22),]
#Estimation
LN_MeanReg(y = y,
           X = X, Xtilde = Xtilde,
           method = "weak_inf", y_transf = FALSE)


}
