% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_deaths_fn.R
\name{predict_deaths_fn}
\alias{predict_deaths_fn}
\title{A function to compute the fitted and forecast number of deaths, accompanied by credible intervals,
from posterior samples generated for stochastic mortality models}
\usage{
predict_deaths_fn(result, expo_forecast = NULL, pred_int = 0.95)
}
\arguments{
\item{result}{object of type either "fit_result" or "BayesMoFo".}

\item{expo_forecast}{An optional 3-dimensional array (of dimensions \eqn{p \times A \times h}) containing exposure data for the forecast period. If not provided, the exposure data from the most recent year will be used for forecasting.}

\item{pred_int}{A numeric value (between 0 and 1) specifying the credible level of uncertainty bands. Default is \code{pred_int=0.95} (\eqn{95\%} intervals).}
}
\value{
An array containing the lower, median, and upper quantiles of the number of deaths for both the fitted and forecast periods.
}
\description{
Return the median fitted and forecast number of deaths, accompanied by credible intervals (user-specified level), using posterior samples stored in "fit_result" object.
}
\examples{
\donttest{
#load and prepare data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#fit any mortality model
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,models="APCI",n_iter=1000)

#default
predict_deaths_fn(runBayesMoFo_result)

#changing pre-specified arguments 
predict_deaths_fn(runBayesMoFo_result,pred_int=0.8)
}
}
\concept{credible intervals}
\concept{fitted deaths}
\concept{forecast deaths}
\keyword{forecasting}
\keyword{models}
