% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesMultMeta.R
\name{split_rank_hatR}
\alias{split_rank_hatR}
\title{Computes the split-\eqn{\hat{R}} estimate based on the rank normalization}
\usage{
split_rank_hatR(MC)
}
\arguments{
\item{MC}{An \eqn{N \times M} matrix with N draws in each of M constructed
Markov chains.}
}
\value{
a value with the the split-\eqn{\hat{R}} estimate based on the rank
normalization
}
\description{
The function computes the split-\eqn{\hat{R}} estimate based on the rank
normalization.
}
\examples{
dataREM<-mvmeta::hyp
# Observation matrix X
X<-t(cbind(dataREM$sbp,dataREM$dbp))
p<-nrow(X) # model dimension
n<-ncol(X) # sample size
# Matrix U
U<-matrix(0,n*p,n*p)
for (i_n in 1:n) {
  Use<-diag(c(dataREM$sbp_se[i_n],dataREM$dbp_se[i_n]))
  Corr_mat<-matrix(c(1,dataREM$rho[i_n],dataREM$rho[i_n],1),p,p)
  U[(p*(i_n-1)+1):(p*i_n),(p*(i_n-1)+1):(p*i_n)]<- Use\%*\%Corr_mat\%*\%Use
}
# Generating M Markov chains for mu_1
M<-4 # number of chains
MC <-NULL
for (i in 1:M) {
  chain <-  BayesMultMeta(X, U, 1e2, burn_in = 1e2,
                          likelihood = "t", prior="jeffrey",
                          algorithm_version = "mu",d=3)
  MC<- cbind(MC,chain$mu[1,])
}
split_rank_hatR(MC)

}
