% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SGV.R
\name{dmnorm_sgv}
\alias{dmnorm_sgv}
\title{Function for the evaluating the SGV approximate density.}
\usage{
dmnorm_sgv(x, mean, U, N, k, log = 1)
}
\arguments{
\item{x}{Vector of measurements}

\item{mean}{Vector of mean valiues}

\item{U}{Matrix of size N x 3; representation of a sparse N x N Cholesky
of the precision matrix. The first two columns contain row and column 
indices, respectively, and the last column is the nonzero elements of the
matrix.}

\item{N}{Number of measurements in x}

\item{k}{Number of neighbors for the SGV approximation.}

\item{log}{Logical; should the density be evaluated on the log scale.}
}
\value{
Returns the SGV approximation to the Gaussian likelihood.
}
\description{
\code{dmnorm_sgv} (and \code{rmnorm_sgv}) calculate the approximate SGV
likelihood for a fixed set of parameters (i.e., the U matrix). Finally,
the distributions must be registered within \code{nimble}.
}
