% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.bin}
\alias{BFpower.bin}
\title{Sample size determination for Bayesian one-proportion test}
\usage{
BFpower.bin(
  hypothesis = NULL,
  interval = NULL,
  D = NULL,
  target = NULL,
  FP = NULL,
  location = NULL,
  model = NULL,
  alpha = NULL,
  beta = NULL,
  scale = NULL,
  model_d = NULL,
  alpha_d = NULL,
  beta_d = NULL,
  location_d = NULL,
  scale_d = NULL,
  de_an_prior = NULL,
  N = NULL,
  mode_bf = NULL,
  e = NULL,
  direct = NULL,
  h0 = NULL
)
}
\arguments{
\item{hypothesis}{The hypothesis being tested (e.g., two-sided \code{"!="}, right-sided \code{">"}, left-sided \code{"<"}).}

\item{interval}{Character or integer (0 or 1). If \code{"1"}, Bayes factor with a point null against a composite alternative hypothesis;
otherwise Bayes factor with interval null and alternative hypotheses.}

\item{D}{The bound of compelling evidence.}

\item{target}{The targeted true positive rate (if \code{direct = "h1"}) or true negative rate (if \code{direct = "h0"}).}

\item{FP}{The targeted false positive rate (if \code{direct = "h1"}) or false negative rate (if \code{direct = "h0"}).}

\item{location}{Null proportion value.}

\item{model}{Statistical model of the analysis prior under the alternative hypothesis: beta prior  (\code{"beta"}) or Moment prior (\code{"Moment"})}

\item{alpha}{Parameter for the analysis prior under the alternative hypothesis.}

\item{beta}{Parameter for the analysis prior under the alternative hypothesis.}

\item{scale}{Scale parameter for the analysis prior under the alternative hypothesis.}

\item{model_d}{Statistical model of the design prior under the alternative hypothesis:beta prior  (\code{"beta"}) , Moment prior (\code{"Moment"}), or Point prior (\code{"Point"})}

\item{alpha_d}{Parameter for the design prior under the alternative hypothesis.}

\item{beta_d}{Parameter for the design prior under the alternative hypothesis.}

\item{location_d}{The proportion value for the design point prior.}

\item{scale_d}{Scale parameter for the design prior under the alternative hypothesis.}

\item{de_an_prior}{Integer (0 or 1). If 1, analysis and design priors under the alternative are the same; if 0, they are not.}

\item{N}{Sample size.}

\item{mode_bf}{Integer (0 or 1). If \code{1}, sample size determination; if \code{2}, \code{N} is needed for the calculation of probabilities of compelling and misleading evidence.}

\item{e}{The bounds for the interval Bayes factor (used when \code{interval = 0}).}

\item{direct}{If \code{"h1"}, BF10; if \code{"h0"}, BF01.}

\item{h0}{Null value}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{p(BF10 > D | H1)}: Probability of obtaining compelling evidence
in favor of the alternative hypothesis when the alternative is true.
\item \code{p(BF01 > D | H1)}: Probability of obtaining misleading evidence
in favor of the null hypothesis when the alternative is true.
\item \code{p(BF01 > D | H0)}: Probability of obtaining compelling evidence
in favor of the null hypothesis when the null is true.
\item \code{p(BF10 > D | H0)}: Probability of obtaining misleading evidence
in favor of the alternative hypothesis when the null is true.
\item \code{Required N}: The required sample size or the sample size input by the users.
}
If sample size determination fails, the function returns \code{NULL}.
}
\description{
Perform sample size determination or the calculation of compelling and misleading evidence
for a Bayesian test of a single proportion.
}
\examples{
BFpower.bin(
  hypothesis = "!=",
  interval = "1",
  D = 3,
  target = 0.8,
  FP = 0.05,
  location = 0.5,
  model = "beta",
  alpha = 1,
  beta = 1,
  de_an_prior = 1,
  mode_bf = 1,
  direct = "h1"
)

}
